/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.record;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class VectorClockTimestamp
implements IdentifiedDataSerializable {
    private Map<Member, Integer> clocks;

    public VectorClockTimestamp() {
        this.clocks = Collections.emptyMap();
    }

    private VectorClockTimestamp(Map<Member, Integer> clocks) {
        this.clocks = Collections.unmodifiableMap(clocks);
    }

    VectorClockTimestamp incrementClock0(Member localMember) {
        HashMap<Member, Integer> copy = new HashMap<Member, Integer>(this.clocks);
        Integer clock = (Integer)copy.get(localMember);
        if (clock == null) {
            clock = 0;
        }
        clock = clock + 1;
        copy.put(localMember, clock);
        return new VectorClockTimestamp(copy);
    }

    VectorClockTimestamp applyVector0(VectorClockTimestamp update) {
        HashMap<Member, Integer> copy = new HashMap<Member, Integer>(this.clocks);
        for (Member m : update.clocks.keySet()) {
            Integer updateClock;
            Integer currentClock = (Integer)copy.get(m);
            if (!this.smaller(currentClock, updateClock = update.clocks.get(m))) continue;
            copy.put(m, updateClock);
        }
        return new VectorClockTimestamp(copy);
    }

    @Override
    public void writeData(ObjectDataOutput dataOutput) throws IOException {
        Map<Member, Integer> clocks = this.clocks;
        dataOutput.writeInt(clocks.size());
        for (Map.Entry<Member, Integer> entry : clocks.entrySet()) {
            entry.getKey().writeData(dataOutput);
            dataOutput.writeInt(entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        HashMap<MemberImpl, Integer> data = new HashMap<MemberImpl, Integer>();
        for (int i = 0; i < size; ++i) {
            MemberImpl m = new MemberImpl();
            m.readData(dataInput);
            int clock = dataInput.readInt();
            data.put(m, clock);
        }
        this.clocks = Collections.unmodifiableMap(data);
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    public String toString() {
        return "Vector{clocks=" + this.clocks + '}';
    }

    private boolean smaller(Integer int1, Integer int2) {
        int i1 = int1 == null ? 0 : int1;
        int i2 = int2 == null ? 0 : int2;
        return i1 < i2;
    }

    static VectorClockTimestamp copyVector(VectorClockTimestamp vectorClockTimestamp) {
        HashMap<Member, Integer> clocks = new HashMap<Member, Integer>();
        for (Map.Entry<Member, Integer> entry : vectorClockTimestamp.clocks.entrySet()) {
            MemberImpl member = new MemberImpl((MemberImpl)entry.getKey());
            Integer value = entry.getValue();
            clocks.put(member, value);
        }
        return new VectorClockTimestamp(clocks);
    }

    static boolean happenedBefore(VectorClockTimestamp x, VectorClockTimestamp y) {
        HashSet<Member> members = new HashSet<Member>(x.clocks.keySet());
        members.addAll(y.clocks.keySet());
        boolean hasLesser = false;
        for (Member m : members) {
            int yi;
            int xi = x.clocks.get(m) != null ? x.clocks.get(m) : 0;
            int n = yi = y.clocks.get(m) != null ? y.clocks.get(m) : 0;
            if (xi > yi) {
                return false;
            }
            if (xi >= yi) continue;
            hasLesser = true;
        }
        return hasLesser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorClockTimestamp that = (VectorClockTimestamp)o;
        return !(this.clocks != null ? !this.clocks.equals(that.clocks) : that.clocks != null);
    }

    public int hashCode() {
        return this.clocks != null ? this.clocks.hashCode() : 0;
    }
}

