/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.multimap.impl.client.TxnMultiMapRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;
import java.security.Permission;

public class TxnMultiMapRemoveRequest
extends TxnMultiMapRequest {
    Data key;
    Data value;

    public TxnMultiMapRemoveRequest() {
    }

    public TxnMultiMapRemoveRequest(String name, Data key) {
        super(name);
        this.key = key;
    }

    public TxnMultiMapRemoveRequest(String name, Data key, Data value) {
        this(name, key);
        this.value = value;
    }

    @Override
    public Object innerCall() throws Exception {
        TransactionContext context = this.getEndpoint().getTransactionContext(this.txnId);
        TransactionalMultiMap multiMap = context.getMultiMap(this.name);
        return multiMap.remove(this.key, this.value);
    }

    @Override
    public int getClassId() {
        return 21;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.value = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "remove");
    }
}

