/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.multimap.impl.client.MultiMapKeyBasedRequest;
import com.hazelcast.multimap.impl.operations.ContainsEntryOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class KeyBasedContainsRequest
extends MultiMapKeyBasedRequest {
    private Data value;
    private long threadId;

    public KeyBasedContainsRequest() {
    }

    public KeyBasedContainsRequest(String name, Data key, Data value) {
        super(name, key);
        this.value = value;
    }

    public KeyBasedContainsRequest(String name, Data key, Data value, long threadId) {
        super(name, key);
        this.value = value;
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        ContainsEntryOperation operation = new ContainsEntryOperation(this.name, this.key, this.value);
        operation.setThreadId(this.threadId);
        return operation;
    }

    @Override
    public int getClassId() {
        return 26;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("threadId", this.threadId);
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("threadId");
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.value = in.readData();
    }

    @Override
    public String getMethodName() {
        if (this.value == null) {
            return "containsKey";
        }
        return "containsEntry";
    }

    @Override
    public Object[] getParameters() {
        if (this.value == null) {
            return new Object[]{this.key};
        }
        return new Object[]{this.key, this.value};
    }
}

