/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PartitionGroupConfig {
    private boolean enabled;
    private MemberGroupType groupType = MemberGroupType.PER_MEMBER;
    private final List<MemberGroupConfig> memberGroupConfigs = new LinkedList<MemberGroupConfig>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public PartitionGroupConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MemberGroupType getGroupType() {
        return this.groupType;
    }

    public PartitionGroupConfig setGroupType(MemberGroupType memberGroupType) {
        this.groupType = Preconditions.isNotNull(memberGroupType, "memberGroupType");
        return this;
    }

    public PartitionGroupConfig addMemberGroupConfig(MemberGroupConfig memberGroupConfig) {
        this.memberGroupConfigs.add(Preconditions.isNotNull(memberGroupConfig, "MemberGroupConfig"));
        return this;
    }

    public Collection<MemberGroupConfig> getMemberGroupConfigs() {
        return Collections.unmodifiableCollection(this.memberGroupConfigs);
    }

    public PartitionGroupConfig clear() {
        this.memberGroupConfigs.clear();
        return this;
    }

    public PartitionGroupConfig setMemberGroupConfigs(Collection<MemberGroupConfig> memberGroupConfigs) {
        Preconditions.isNotNull(memberGroupConfigs, "memberGroupConfigs");
        this.memberGroupConfigs.clear();
        this.memberGroupConfigs.addAll(memberGroupConfigs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionGroupConfig");
        sb.append("{enabled=").append(this.enabled);
        sb.append(", groupType=").append((Object)this.groupType);
        sb.append(", memberGroupConfigs=").append(this.memberGroupConfigs);
        sb.append('}');
        return sb.toString();
    }

    public static enum MemberGroupType {
        HOST_AWARE,
        CUSTOM,
        PER_MEMBER;

    }
}

