/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlUnnestOperator;
import com.hazelcast.org.apache.calcite.sql.validate.AbstractNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlQualified;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;

class UnnestNamespace
extends AbstractNamespace {
    private final SqlCall unnest;
    private final SqlValidatorScope scope;

    UnnestNamespace(SqlValidatorImpl validator, SqlCall unnest, SqlValidatorScope scope, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        assert (scope != null);
        assert (unnest.getOperator() instanceof SqlUnnestOperator);
        this.unnest = unnest;
        this.scope = scope;
    }

    @Override
    public SqlValidatorTable getTable() {
        Object toUnnest = this.unnest.operand(0);
        if (toUnnest instanceof SqlIdentifier) {
            SqlIdentifier id = (SqlIdentifier)toUnnest;
            SqlQualified qualified = this.scope.fullyQualify(id);
            return qualified.namespace.getTable();
        }
        return null;
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.validateCall(this.unnest, this.scope);
        RelDataType type = this.unnest.getOperator().validateOperands(this.validator, this.scope, this.unnest);
        return this.toStruct(type, this.unnest);
    }

    @Override
    public SqlNode getNode() {
        return this.unnest;
    }
}

