/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rex.RexBiVisitor;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.sql.SqlKind;

public class RexFieldAccess
extends RexNode {
    private final RexNode expr;
    private final RelDataTypeField field;

    RexFieldAccess(RexNode expr, RelDataTypeField field) {
        this.expr = expr;
        this.field = field;
        this.digest = expr + "." + field.getName();
        assert (expr.getType().getFieldList().get(field.getIndex()) == field);
    }

    public RelDataTypeField getField() {
        return this.field;
    }

    @Override
    public RelDataType getType() {
        return this.field.getType();
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.FIELD_ACCESS;
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitFieldAccess(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitFieldAccess(this, arg);
    }

    public RexNode getReferenceExpr() {
        return this.expr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RexFieldAccess that = (RexFieldAccess)o;
        return this.field.equals(that.field) && this.expr.equals(that.expr);
    }

    @Override
    public int hashCode() {
        int result = this.expr.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }
}

