/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import com.hazelcast.util.Clock;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ClientInvocation
implements Runnable {
    private static final int MAX_FAST_INVOCATION_COUNT = 5;
    private static final int UNASSIGNED_PARTITION = -1;
    private static final AtomicLongFieldUpdater<ClientInvocation> INVOKE_COUNT = AtomicLongFieldUpdater.newUpdater(ClientInvocation.class, "invokeCount");
    private final ClientInvocationFuture clientInvocationFuture;
    private final ILogger logger;
    private final LifecycleService lifecycleService;
    private final ClientClusterService clientClusterService;
    private final AbstractClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private volatile ClientMessage clientMessage;
    private final CallIdSequence callIdSequence;
    private final Address address;
    private final int partitionId;
    private final Connection connection;
    private final long startTimeMillis;
    private final long retryPauseMillis;
    private final String objectName;
    private volatile ClientConnection sendConnection;
    private EventHandler handler;
    private volatile long invokeCount;
    private volatile long invocationTimeoutMillis;

    protected ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, String objectName, int partitionId, Address address, Connection connection) {
        this.clientClusterService = client.getClientClusterService();
        this.lifecycleService = client.getLifecycleService();
        this.invocationService = (AbstractClientInvocationService)client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.objectName = objectName;
        this.clientMessage = clientMessage;
        this.partitionId = partitionId;
        this.address = address;
        this.connection = connection;
        this.startTimeMillis = System.currentTimeMillis();
        this.retryPauseMillis = this.invocationService.getInvocationRetryPauseMillis();
        this.logger = this.invocationService.invocationLogger;
        this.callIdSequence = this.invocationService.getCallIdSequence();
        this.clientInvocationFuture = new ClientInvocationFuture(this, this.executionService, clientMessage, this.logger, this.callIdSequence);
        this.invocationTimeoutMillis = this.invocationService.getInvocationTimeoutMillis();
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, String objectName) {
        this(client, clientMessage, objectName, -1, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, String objectName, int partitionId) {
        this(client, clientMessage, objectName, partitionId, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, String objectName, Address address) {
        this(client, clientMessage, objectName, -1, address, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, String objectName, Connection connection) {
        this(client, clientMessage, objectName, -1, null, connection);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ClientMessage getClientMessage() {
        return this.clientMessage;
    }

    public ClientInvocationFuture invoke() {
        assert (this.clientMessage != null);
        this.clientMessage.setCorrelationId(this.callIdSequence.next());
        this.invokeOnSelection();
        return this.clientInvocationFuture;
    }

    public ClientInvocationFuture invokeUrgent() {
        assert (this.clientMessage != null);
        this.clientMessage.setCorrelationId(this.callIdSequence.forceNext());
        this.invokeOnSelection();
        return this.clientInvocationFuture;
    }

    private void invokeOnSelection() {
        INVOKE_COUNT.incrementAndGet(this);
        try {
            if (this.isBindToSingleConnection()) {
                this.invocationService.invokeOnConnection(this, (ClientConnection)this.connection);
            } else if (this.partitionId != -1) {
                this.invocationService.invokeOnPartitionOwner(this, this.partitionId);
            } else if (this.address != null) {
                this.invocationService.invokeOnTarget(this, this.address);
            } else {
                this.invocationService.invokeOnRandomTarget(this);
            }
        }
        catch (Exception e) {
            if (e instanceof HazelcastOverloadException) {
                throw (HazelcastOverloadException)e;
            }
            this.notifyException(e);
        }
    }

    @Override
    public void run() {
        this.retry();
    }

    private void retry() {
        this.clientMessage = this.clientMessage.copy();
        this.clientMessage.setCorrelationId(this.callIdSequence.forceNext());
        this.callIdSequence.complete();
        try {
            this.invokeOnSelection();
        }
        catch (Throwable e) {
            this.clientInvocationFuture.complete(e);
        }
    }

    public void setInvocationTimeoutMillis(long invocationTimeoutMillis) {
        this.invocationTimeoutMillis = invocationTimeoutMillis;
    }

    public void notify(ClientMessage clientMessage) {
        if (clientMessage == null) {
            throw new IllegalArgumentException("response can't be null");
        }
        this.clientInvocationFuture.complete(clientMessage);
    }

    public void notifyException(Throwable exception) {
        boolean retry;
        this.logException(exception);
        if (!this.lifecycleService.isRunning()) {
            this.clientInvocationFuture.complete(new HazelcastClientNotActiveException("Client is shutting down", exception));
            return;
        }
        if (this.isNotAllowedToRetryOnSelection(exception)) {
            this.clientInvocationFuture.complete(exception);
            return;
        }
        boolean bl = retry = ClientInvocation.isRetrySafeException(exception) || this.invocationService.isRedoOperation() || exception instanceof TargetDisconnectedException && this.clientMessage.isRetryable();
        if (!retry) {
            this.clientInvocationFuture.complete(exception);
            return;
        }
        long timePassed = System.currentTimeMillis() - this.startTimeMillis;
        if (timePassed > this.invocationTimeoutMillis) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Exception will not be retried because invocation timed out", exception);
            }
            this.clientInvocationFuture.complete(this.newOperationTimeoutException(exception));
            return;
        }
        try {
            this.execute();
        }
        catch (RejectedExecutionException e) {
            this.clientInvocationFuture.complete(new HazelcastClientNotActiveException("Client is shutting down", exception));
        }
    }

    private void logException(Throwable exception) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Invocation got an exception " + this + ", invoke count : " + this.invokeCount + ", exception : " + exception.getClass() + ", message : " + exception.getMessage() + (exception.getCause() != null ? ", cause :" + exception.getCause() : ""));
        }
    }

    private void execute() {
        if (this.invokeCount < 5L) {
            this.executionService.execute(this);
        } else {
            long delayMillis = Math.min((long)(1 << (int)(this.invokeCount - 5L)), this.retryPauseMillis);
            this.executionService.schedule(this, delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private boolean isNotAllowedToRetryOnSelection(Throwable exception) {
        if (this.isBindToSingleConnection() && exception instanceof IOException) {
            return true;
        }
        return this.address != null && exception instanceof TargetNotMemberException && this.clientClusterService.getMember(this.address) == null;
    }

    private boolean isBindToSingleConnection() {
        return this.connection != null;
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public void setEventHandler(EventHandler handler) {
        this.handler = handler;
    }

    public void setSendConnection(ClientConnection connection) {
        this.sendConnection = connection;
    }

    public ClientConnection getSendConnectionOrWait() throws InterruptedException {
        while (this.sendConnection == null && !this.clientInvocationFuture.isDone()) {
            Thread.sleep(this.retryPauseMillis);
        }
        return this.sendConnection;
    }

    public ClientConnection getSendConnection() {
        return this.sendConnection;
    }

    public static boolean isRetrySafeException(Throwable t) {
        return t instanceof IOException || t instanceof HazelcastInstanceNotActiveException || t instanceof RetryableException;
    }

    public Executor getUserExecutor() {
        return this.executionService.getUserExecutor();
    }

    private Object newOperationTimeoutException(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(this);
        sb.append(" timed out because exception occurred after client invocation timeout ");
        sb.append(this.invocationService.getInvocationTimeoutMillis()).append(" ms. ");
        sb.append("Current time: ").append(StringUtil.timeToString(Clock.currentTimeMillis())).append(". ");
        sb.append("Start time: ").append(StringUtil.timeToString(this.startTimeMillis)).append(". ");
        sb.append("Total elapsed time: ").append(Clock.currentTimeMillis() - this.startTimeMillis).append(" ms. ");
        String msg = sb.toString();
        return new OperationTimeoutException(msg, e);
    }

    public String toString() {
        String target = this.isBindToSingleConnection() ? "connection " + this.connection : (this.partitionId != -1 ? "partition " + this.partitionId : (this.address != null ? "address " + this.address : "random"));
        return "ClientInvocation{clientMessage = " + this.clientMessage + ", objectName = " + this.objectName + ", target = " + target + ", sendConnection = " + this.sendConnection + '}';
    }
}

