/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/openexchange/osgi/tasks/ClasspathPrinter;", "Lorg/gradle/api/DefaultTask;", "()V", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "pathName", "Lorg/gradle/api/provider/Property;", "", "getPathName", "()Lorg/gradle/api/provider/Property;", "printClasspath", "", "osgi"})
public class ClasspathPrinter
extends DefaultTask {
    @Input
    @NotNull
    private final Property<String> pathName;
    @InputFiles
    @NotNull
    private final ConfigurableFileCollection classpath;

    public ClasspathPrinter() {
        Property property = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.pathName = property;
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.classpath = configurableFileCollection;
    }

    @NotNull
    public final Property<String> getPathName() {
        return this.pathName;
    }

    @NotNull
    public final ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @TaskAction
    public final void printClasspath() {
        this.getLogger().quiet("Classpath: " + (String)this.pathName.get() + ':');
        Iterable $this$forEach$iv = (Iterable)this.classpath;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.getLogger().quiet("- " + it.getAbsolutePath());
        }
    }
}

