/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.OSGIManifest;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarModule
extends AbstractModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarModule(File file) throws IOException {
        super(file);
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                this.osgiManifest = new OSGIManifest(manifest);
                this.name = this.osgiManifest.getEntry("Bundle-SymbolicName");
            }
            if (this.name == null) {
                this.name = file.getName();
            }
        }
    }

    @Override
    public Set<String> getExportedClasspath() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(this.file.getAbsolutePath());
        return Collections.unmodifiableSet(retval);
    }

    @Override
    protected Set<String> getRuntimeClasspath() {
        return this.getExportedClasspath();
    }
}

