/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.CommandLineTool;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\nJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/openexchange/osgi/data/ProjectDatabase;", "", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "projects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/openexchange/osgi/data/CommandLineTool;", "addProject", "", "clt", "clear", "projectsIterator", "Ljava/util/Enumeration;", "osgi"})
public final class ProjectDatabase {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, CommandLineTool> projects;

    public ProjectDatabase(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.projects = new ConcurrentHashMap();
    }

    public final void addProject(@NotNull CommandLineTool clt) {
        Intrinsics.checkNotNullParameter((Object)clt, (String)"clt");
        CommandLineTool commandLineTool = this.projects.get(clt.getName());
        if (commandLineTool != null) {
            CommandLineTool other = commandLineTool;
            boolean bl = false;
            throw new GradleException("Duplicate command line tool " + clt.getName() + " found. Other command line tool is " + other.getName() + '.');
        }
        ((Map)this.projects).put(clt.getName(), clt);
    }

    @NotNull
    public final Enumeration<String> projectsIterator() {
        Enumeration<String> enumeration = this.projects.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"projects.keys()");
        return enumeration;
    }

    public final void clear() {
        this.projects.clear();
    }
}

