/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxPKCEManager;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.IncludeGrantedScopes;
import com.dropbox.core.TokenAccessType;
import com.dropbox.core.android.DbxOfficialAppConnector;
import com.dropbox.core.android.FixedSecureRandom;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class AuthActivity
extends Activity {
    private static final String TAG = AuthActivity.class.getName();
    public static final String EXTRA_CONSUMER_KEY = "CONSUMER_KEY";
    public static final String EXTRA_ACCESS_TOKEN = "ACCESS_TOKEN";
    public static final String EXTRA_ACCESS_SECRET = "ACCESS_SECRET";
    public static final String EXTRA_UID = "UID";
    public static final String EXTRA_REFRESH_TOKEN = "REFRESH_TOKEN";
    public static final String EXTRA_EXPIRES_AT = "EXPIRES_AT";
    public static final String EXTRA_SCOPE = "SCOPE";
    public static final String EXTRA_CONSUMER_SIG = "CONSUMER_SIG";
    public static final String EXTRA_CALLING_PACKAGE = "CALLING_PACKAGE";
    public static final String EXTRA_CALLING_CLASS = "CALLING_CLASS";
    public static final String EXTRA_AUTH_STATE = "AUTH_STATE";
    public static final String EXTRA_DESIRED_UID = "DESIRED_UID";
    public static final String EXTRA_ALREADY_AUTHED_UIDS = "ALREADY_AUTHED_UIDS";
    public static final String EXTRA_SESSION_ID = "SESSION_ID";
    public static final String EXTRA_AUTH_QUERY_PARAMS = "AUTH_QUERY_PARAMS";
    public static final String ACTION_AUTHENTICATE_V1 = "com.dropbox.android.AUTHENTICATE_V1";
    public static final String ACTION_AUTHENTICATE_V2 = "com.dropbox.android.AUTHENTICATE_V2";
    public static final int AUTH_VERSION = 1;
    public static final String AUTH_PATH_CONNECT = "/connect";
    private static final String DEFAULT_WEB_HOST = "www.dropbox.com";
    private static final String SIS_KEY_AUTH_STATE_NONCE = "SIS_KEY_AUTH_STATE_NONCE";
    private static final String SIS_KEY_PKCE_CODE_VERIFIER = "SIS_KEY_PKCE_CODE_VERIFIER";
    private static SecurityProvider sSecurityProvider = new SecurityProvider(){

        @Override
        public SecureRandom getSecureRandom() {
            return FixedSecureRandom.get();
        }
    };
    private static final Object sSecurityProviderLock = new Object();
    public static Intent result = null;
    private static String sAppKey;
    private static String sApiType;
    private static String sDesiredUid;
    private static String[] sAlreadyAuthedUids;
    private static String sSessionId;
    private static TokenAccessType sTokenAccessType;
    private static DbxRequestConfig sRequestConfig;
    private static DbxHost sHost;
    private static String sScope;
    private static IncludeGrantedScopes sIncludeGrantedScopes;
    private String mAppKey;
    private String mApiType;
    private String mDesiredUid;
    private String[] mAlreadyAuthedUids;
    private String mSessionId;
    private TokenAccessType mTokenAccessType;
    private DbxPKCEManager mPKCEManager;
    private DbxRequestConfig mRequestConfig;
    private DbxHost mHost;
    private String mScope;
    private IncludeGrantedScopes mIncludeGrantedScopes;
    private String mAuthStateNonce = null;
    private boolean mActivityDispatchHandlerPosted = false;

    static void setAuthParams(String appKey, String desiredUid, String[] alreadyAuthedUids) {
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, null);
    }

    static void setAuthParams(String appKey, String desiredUid, String[] alreadyAuthedUids, String webHost, String apiType) {
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, null, null, null, null, null, null, null, null);
    }

    static void setAuthParams(String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId) {
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, sessionId, null, null, null, null, null, null, null);
    }

    static void setAuthParams(String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost, String apiType, TokenAccessType tokenAccessType, DbxRequestConfig requestConfig, DbxHost host, String scope, IncludeGrantedScopes includeGrantedScopes) {
        sAppKey = appKey;
        sDesiredUid = desiredUid;
        sAlreadyAuthedUids = alreadyAuthedUids != null ? alreadyAuthedUids : new String[]{};
        sSessionId = sessionId;
        sApiType = apiType;
        sTokenAccessType = tokenAccessType;
        sRequestConfig = requestConfig;
        sHost = host != null ? host : (webHost != null ? new DbxHost(DbxHost.DEFAULT.getApi(), DbxHost.DEFAULT.getContent(), webHost, DbxHost.DEFAULT.getNotify()) : DbxHost.DEFAULT);
        sScope = scope;
        sIncludeGrantedScopes = includeGrantedScopes;
    }

    public static Intent makeIntent(Context context, String appKey, String webHost, String apiType) {
        return AuthActivity.makeIntent(context, appKey, null, null, null, webHost, apiType, null, null, null, null, null);
    }

    public static Intent makeIntent(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost, String apiType) {
        if (appKey == null) {
            throw new IllegalArgumentException("'appKey' can't be null");
        }
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType, null, null, null, null, null);
        return new Intent(context, AuthActivity.class);
    }

    static Intent makeIntent(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost, String apiType, TokenAccessType tokenAccessType, DbxRequestConfig requestConfig, DbxHost host, String scope, IncludeGrantedScopes includeGrantedScopes) {
        if (appKey == null) {
            throw new IllegalArgumentException("'appKey' can't be null");
        }
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType, tokenAccessType, requestConfig, host, scope, includeGrantedScopes);
        return new Intent(context, AuthActivity.class);
    }

    public static boolean checkAppBeforeAuth(Context context, String appKey, boolean alertUser) {
        Intent testIntent = new Intent("android.intent.action.VIEW");
        String scheme = "db-" + appKey;
        String uri = scheme + "://" + 1 + AUTH_PATH_CONNECT;
        testIntent.setData(Uri.parse((String)uri));
        PackageManager pm = context.getPackageManager();
        List activities = pm.queryIntentActivities(testIntent, 0);
        if (null == activities || 0 == activities.size()) {
            throw new IllegalStateException("URI scheme in your app's manifest is not set up correctly. You should have a " + AuthActivity.class.getName() + " with the scheme: " + scheme);
        }
        if (activities.size() > 1) {
            if (alertUser) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setTitle((CharSequence)"Security alert");
                builder.setMessage((CharSequence)"Another app on your phone may be trying to pose as the app you are currently using. The malicious app can't access your account, but linking to Dropbox has been disabled as a precaution. Please contact support@dropbox.com.");
                builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                builder.show();
            } else {
                Log.w((String)TAG, (String)("There are multiple apps registered for the AuthActivity URI scheme (" + scheme + ").  Another app may be trying to  impersonate this app, so authentication will be disabled."));
            }
            return false;
        }
        ResolveInfo resolveInfo = (ResolveInfo)activities.get(0);
        if (null == resolveInfo || null == resolveInfo.activityInfo || !context.getPackageName().equals(resolveInfo.activityInfo.packageName)) {
            throw new IllegalStateException("There must be a " + AuthActivity.class.getName() + " within your app's package registered for your URI scheme (" + scheme + "). However, it appears that an activity in a different package is registered for that scheme instead. If you have multiple apps that all want to use the same accesstoken pair, designate one of them to do authentication and have the other apps launch it and then retrieve the token pair from it.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSecurityProvider(SecurityProvider prov) {
        Object object = sSecurityProviderLock;
        synchronized (object) {
            sSecurityProvider = prov;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityProvider getSecurityProvider() {
        Object object = sSecurityProviderLock;
        synchronized (object) {
            return sSecurityProvider;
        }
    }

    private static SecureRandom getSecureRandom() {
        SecurityProvider prov = AuthActivity.getSecurityProvider();
        if (null != prov) {
            return prov.getSecureRandom();
        }
        return new SecureRandom();
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.mAppKey = sAppKey;
        this.mApiType = sApiType;
        this.mDesiredUid = sDesiredUid;
        this.mAlreadyAuthedUids = sAlreadyAuthedUids;
        this.mSessionId = sSessionId;
        this.mTokenAccessType = sTokenAccessType;
        this.mRequestConfig = sRequestConfig;
        this.mHost = sHost;
        this.mScope = sScope;
        this.mIncludeGrantedScopes = sIncludeGrantedScopes;
        if (savedInstanceState == null) {
            result = null;
            this.mAuthStateNonce = null;
            this.mPKCEManager = new DbxPKCEManager();
        } else {
            this.mAuthStateNonce = savedInstanceState.getString(SIS_KEY_AUTH_STATE_NONCE);
            this.mPKCEManager = new DbxPKCEManager(savedInstanceState.getString(SIS_KEY_PKCE_CODE_VERIFIER));
        }
        this.setTheme(0x1030010);
        super.onCreate(savedInstanceState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(SIS_KEY_AUTH_STATE_NONCE, this.mAuthStateNonce);
        outState.putString(SIS_KEY_PKCE_CODE_VERIFIER, this.mPKCEManager.getCodeVerifier());
    }

    static Intent getOfficialAuthIntent() {
        Intent authIntent = new Intent(ACTION_AUTHENTICATE_V2);
        authIntent.setPackage("com.dropbox.android");
        return authIntent;
    }

    protected void onResume() {
        String state;
        boolean authNotFinish;
        super.onResume();
        if (this.isFinishing()) {
            return;
        }
        boolean bl = authNotFinish = this.mAuthStateNonce != null || this.mAppKey == null;
        if (authNotFinish) {
            this.authFinished(null);
            return;
        }
        result = null;
        if (this.mActivityDispatchHandlerPosted) {
            Log.w((String)TAG, (String)"onResume called again before Handler run");
            return;
        }
        final Intent officialAuthIntent = AuthActivity.getOfficialAuthIntent();
        if (this.mTokenAccessType != null) {
            state = this.createPKCEStateNonce();
            officialAuthIntent.putExtra(EXTRA_AUTH_QUERY_PARAMS, this.createExtraQueryParams());
        } else {
            state = this.createStateNonce();
        }
        officialAuthIntent.putExtra(EXTRA_CONSUMER_KEY, this.mAppKey);
        officialAuthIntent.putExtra(EXTRA_CONSUMER_SIG, "");
        officialAuthIntent.putExtra(EXTRA_CALLING_PACKAGE, this.getPackageName());
        officialAuthIntent.putExtra(EXTRA_CALLING_CLASS, ((Object)((Object)this)).getClass().getName());
        officialAuthIntent.putExtra(EXTRA_AUTH_STATE, state);
        officialAuthIntent.putExtra(EXTRA_DESIRED_UID, this.mDesiredUid);
        officialAuthIntent.putExtra(EXTRA_ALREADY_AUTHED_UIDS, this.mAlreadyAuthedUids);
        officialAuthIntent.putExtra(EXTRA_SESSION_ID, this.mSessionId);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"running startActivity in handler");
                try {
                    if (DbxOfficialAppConnector.getDropboxAppPackage((Context)AuthActivity.this, officialAuthIntent) != null) {
                        AuthActivity.this.startActivity(officialAuthIntent);
                    } else {
                        AuthActivity.this.startWebAuth(state);
                    }
                }
                catch (ActivityNotFoundException e) {
                    Log.e((String)TAG, (String)"Could not launch intent. User may have restricted profile", (Throwable)e);
                    AuthActivity.this.finish();
                    return;
                }
                AuthActivity.this.mAuthStateNonce = state;
                AuthActivity.setAuthParams(null, null, null);
            }
        });
        this.mActivityDispatchHandlerPosted = true;
    }

    protected void onNewIntent(Intent intent) {
        Intent newResult;
        block16: {
            if (null == this.mAuthStateNonce) {
                this.authFinished(null);
                return;
            }
            String token = null;
            String secret = null;
            String uid = null;
            String state = null;
            if (intent.hasExtra(EXTRA_ACCESS_TOKEN)) {
                token = intent.getStringExtra(EXTRA_ACCESS_TOKEN);
                secret = intent.getStringExtra(EXTRA_ACCESS_SECRET);
                uid = intent.getStringExtra(EXTRA_UID);
                state = intent.getStringExtra(EXTRA_AUTH_STATE);
            } else {
                String path;
                Uri uri = intent.getData();
                if (uri != null && AUTH_PATH_CONNECT.equals(path = uri.getPath())) {
                    try {
                        token = uri.getQueryParameter("oauth_token");
                        secret = uri.getQueryParameter("oauth_token_secret");
                        uid = uri.getQueryParameter("uid");
                        state = uri.getQueryParameter("state");
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
            if (!(token == null || token.equals("") || secret == null || secret.equals("") || uid == null || uid.equals("") || state == null || state.equals(""))) {
                if (!this.mAuthStateNonce.equals(state)) {
                    this.authFinished(null);
                    return;
                }
                if (token.equals(TokenType.OAUTH2.toString())) {
                    newResult = new Intent();
                    newResult.putExtra(EXTRA_ACCESS_TOKEN, token);
                    newResult.putExtra(EXTRA_ACCESS_SECRET, secret);
                    newResult.putExtra(EXTRA_UID, uid);
                } else if (token.equals(TokenType.OAUTH2CODE.toString())) {
                    TokenRequestAsyncTask tokenRequest = new TokenRequestAsyncTask(secret);
                    try {
                        DbxAuthFinish dbxAuthFinish = (DbxAuthFinish)tokenRequest.execute(new Void[0]).get();
                        if (dbxAuthFinish == null) {
                            newResult = null;
                            break block16;
                        }
                        newResult = new Intent();
                        newResult.putExtra(EXTRA_ACCESS_TOKEN, dbxAuthFinish.getAccessToken());
                        newResult.putExtra(EXTRA_ACCESS_SECRET, dbxAuthFinish.getAccessToken());
                        newResult.putExtra(EXTRA_REFRESH_TOKEN, dbxAuthFinish.getRefreshToken());
                        newResult.putExtra(EXTRA_EXPIRES_AT, (Serializable)dbxAuthFinish.getExpiresAt());
                        newResult.putExtra(EXTRA_UID, dbxAuthFinish.getUserId());
                        newResult.putExtra(EXTRA_CONSUMER_KEY, this.mAppKey);
                        newResult.putExtra(EXTRA_SCOPE, dbxAuthFinish.getScope());
                    }
                    catch (Exception e) {
                        newResult = null;
                    }
                } else {
                    newResult = null;
                }
            } else {
                newResult = null;
            }
        }
        this.authFinished(newResult);
    }

    private void authFinished(Intent authResult) {
        result = authResult;
        this.mAuthStateNonce = null;
        AuthActivity.setAuthParams(null, null, null);
        this.finish();
    }

    private void startWebAuth(String state) {
        String path = "1/connect";
        Locale locale = Locale.getDefault();
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        String alreadyAuthedUid = this.mAlreadyAuthedUids.length > 0 ? this.mAlreadyAuthedUids[0] : "0";
        ArrayList<String> params = new ArrayList<String>(Arrays.asList("k", this.mAppKey, "n", alreadyAuthedUid, "api", this.mApiType, "state", state));
        if (this.mTokenAccessType != null) {
            params.add("extra_query_params");
            params.add(this.createExtraQueryParams());
        }
        String url = DbxRequestUtil.buildUrlWithParams(locale.toString(), this.mHost.getWeb(), path, params.toArray(new String[0]));
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.startActivity(intent);
    }

    private String createStateNonce() {
        int NONCE_BYTES = 16;
        byte[] randomBytes = new byte[16];
        AuthActivity.getSecureRandom().nextBytes(randomBytes);
        StringBuilder sb = new StringBuilder();
        sb.append("oauth2:");
        for (int i = 0; i < 16; ++i) {
            sb.append(String.format("%02x", randomBytes[i] & 0xFF));
        }
        return sb.toString();
    }

    private String createPKCEStateNonce() {
        String state = String.format(Locale.US, "oauth2code:%s:%s:%s", this.mPKCEManager.getCodeChallenge(), "S256", this.mTokenAccessType.toString());
        if (this.mScope != null) {
            state = state + ":" + this.mScope;
        }
        if (this.mIncludeGrantedScopes != null) {
            state = state + ":" + this.mIncludeGrantedScopes.toString();
        }
        return state;
    }

    private String createExtraQueryParams() {
        if (this.mTokenAccessType == null) {
            throw new IllegalStateException("Extra Query Param should only be used in short live token flow.");
        }
        String param = String.format(Locale.US, "%s=%s&%s=%s&%s=%s&%s=%s", "code_challenge", this.mPKCEManager.getCodeChallenge(), "code_challenge_method", "S256", "token_access_type", this.mTokenAccessType.toString(), "response_type", "code");
        if (this.mScope != null) {
            param = param + String.format(Locale.US, "&%s=%s", "scope", this.mScope);
        }
        if (this.mIncludeGrantedScopes != null) {
            param = param + String.format(Locale.US, "&%s=%s", "include_granted_scopes", this.mIncludeGrantedScopes.toString());
        }
        return param;
    }

    private class TokenRequestAsyncTask
    extends AsyncTask<Void, Void, DbxAuthFinish> {
        private final String code;

        private TokenRequestAsyncTask(String code) {
            this.code = code;
        }

        protected DbxAuthFinish doInBackground(Void ... p) {
            try {
                return AuthActivity.this.mPKCEManager.makeTokenRequest(AuthActivity.this.mRequestConfig, this.code, AuthActivity.this.mAppKey, null, AuthActivity.this.mHost);
            }
            catch (DbxException e) {
                Log.e((String)TAG, (String)("Token Request Failed: " + e.getMessage()));
                return null;
            }
        }
    }

    private static enum TokenType {
        OAUTH2("oauth2:"),
        OAUTH2CODE("oauth2code:");

        private String string;

        private TokenType(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    public static interface SecurityProvider {
        public SecureRandom getSecureRandom();
    }
}

