/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultCompactWriter
implements CompactWriter {
    private final CompactStreamSerializer serializer;
    private final Schema schema;
    private final BufferObjectDataOutput out;
    private final int dataStartPosition;
    private final int[] fieldOffsets;
    private final boolean includeSchemaOnBinary;

    public DefaultCompactWriter(CompactStreamSerializer serializer, BufferObjectDataOutput out, Schema schema, boolean includeSchemaOnBinary) {
        this.serializer = serializer;
        this.out = out;
        this.schema = schema;
        if (schema.getNumberOfVariableSizeFields() != 0) {
            this.fieldOffsets = new int[schema.getNumberOfVariableSizeFields()];
            this.dataStartPosition = out.position() + 4;
            out.writeZeroBytes(schema.getFixedSizeFieldsLength() + 4);
        } else {
            this.fieldOffsets = null;
            this.dataStartPosition = out.position();
            out.writeZeroBytes(schema.getFixedSizeFieldsLength());
        }
        this.includeSchemaOnBinary = includeSchemaOnBinary;
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }

    public void end() {
        try {
            if (this.schema.getNumberOfVariableSizeFields() == 0) {
                return;
            }
            int position = this.out.position();
            int dataLength = position - this.dataStartPosition;
            this.writeOffsets(dataLength, this.fieldOffsets);
            this.out.writeInt(this.dataStartPosition - 4, dataLength);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    private void writeOffsets(int dataLength, int[] offsets) throws IOException {
        if (dataLength < 255) {
            for (int offset : offsets) {
                this.out.writeByte(offset);
            }
        } else if (dataLength < 65535) {
            for (int offset : offsets) {
                this.out.writeShort(offset);
            }
        } else {
            for (int offset : offsets) {
                this.out.writeInt(offset);
            }
        }
    }

    @Override
    public void writeInt(@Nonnull String fieldName, int value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldType.INT);
        try {
            this.out.writeInt(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeLong(@Nonnull String fieldName, long value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldType.LONG);
        try {
            this.out.writeLong(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeBoolean(@Nonnull String fieldName, boolean value) {
        FieldDescriptor fieldDefinition = this.checkFieldDefinition(fieldName, FieldType.BOOLEAN);
        int offsetInBytes = fieldDefinition.getOffset();
        byte offsetInBits = fieldDefinition.getBitOffset();
        int writeOffset = offsetInBytes + this.dataStartPosition;
        try {
            this.out.writeBooleanBit(writeOffset, offsetInBits, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    private IllegalStateException illegalStateException(IOException cause) {
        return new IllegalStateException("IOException is not expected from BufferObjectDataOutput ", cause);
    }

    @Override
    public void writeByte(@Nonnull String fieldName, byte value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldType.BYTE);
        try {
            this.out.writeByte(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeChar(@Nonnull String fieldName, char value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldType.CHAR);
        try {
            this.out.writeChar(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeDouble(@Nonnull String fieldName, double value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldType.DOUBLE);
        try {
            this.out.writeDouble(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeFloat(@Nonnull String fieldName, float value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldType.FLOAT);
        try {
            this.out.writeFloat(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeShort(@Nonnull String fieldName, short value) {
        int position = this.getFixedSizeFieldPosition(fieldName, FieldType.SHORT);
        try {
            this.out.writeShort(position, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    protected <T> void writeVariableSizeField(@Nonnull String fieldName, FieldType fieldType, T object, Writer<T> writer) {
        try {
            if (object == null) {
                this.setPositionAsNull(fieldName, fieldType);
            } else {
                this.setPosition(fieldName, fieldType);
                writer.write(this.out, object);
            }
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeString(@Nonnull String fieldName, String str) {
        this.writeVariableSizeField(fieldName, FieldType.UTF, str, ObjectDataOutput::writeString);
    }

    public void writeObject(@Nonnull String fieldName, Object value) {
        this.writeVariableSizeField(fieldName, FieldType.COMPOSED, value, (out, val) -> this.serializer.writeObject(out, val, this.includeSchemaOnBinary));
    }

    public void writeGenericRecord(@Nonnull String fieldName, GenericRecord value) {
        this.writeVariableSizeField(fieldName, FieldType.COMPOSED, value, (out, val) -> this.serializer.writeGenericRecord(out, (CompactGenericRecord)val, this.includeSchemaOnBinary));
    }

    @Override
    public void writeDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        this.writeVariableSizeField(fieldName, FieldType.DECIMAL, value, IOUtil::writeBigDecimal);
    }

    @Override
    public void writeTime(@Nonnull String fieldName, @Nonnull LocalTime value) {
        int lastPos = this.out.position();
        try {
            this.out.position(this.getFixedSizeFieldPosition(fieldName, FieldType.TIME));
            IOUtil.writeLocalTime(this.out, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.out.position(lastPos);
        }
    }

    @Override
    public void writeDate(@Nonnull String fieldName, @Nonnull LocalDate value) {
        int lastPos = this.out.position();
        try {
            this.out.position(this.getFixedSizeFieldPosition(fieldName, FieldType.DATE));
            IOUtil.writeLocalDate(this.out, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.out.position(lastPos);
        }
    }

    @Override
    public void writeTimestamp(@Nonnull String fieldName, @Nonnull LocalDateTime value) {
        int lastPos = this.out.position();
        try {
            this.out.position(this.getFixedSizeFieldPosition(fieldName, FieldType.TIMESTAMP));
            IOUtil.writeLocalDateTime(this.out, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.out.position(lastPos);
        }
    }

    @Override
    public void writeTimestampWithTimezone(@Nonnull String fieldName, @Nonnull OffsetDateTime value) {
        int lastPos = this.out.position();
        try {
            this.out.position(this.getFixedSizeFieldPosition(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE));
            IOUtil.writeOffsetDateTime(this.out, value);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.out.position(lastPos);
        }
    }

    @Override
    public void writeByteArray(@Nonnull String fieldName, @Nullable byte[] values) {
        this.writeVariableSizeField(fieldName, FieldType.BYTE_ARRAY, values, ObjectDataOutput::writeByteArray);
    }

    @Override
    public void writeBooleanArray(@Nonnull String fieldName, @Nullable boolean[] values) {
        this.writeVariableSizeField(fieldName, FieldType.BOOLEAN_ARRAY, values, DefaultCompactWriter::writeBooleanBits);
    }

    @Override
    public void writeCharArray(@Nonnull String fieldName, @Nullable char[] values) {
        this.writeVariableSizeField(fieldName, FieldType.CHAR_ARRAY, values, ObjectDataOutput::writeCharArray);
    }

    @Override
    public void writeIntArray(@Nonnull String fieldName, @Nullable int[] values) {
        this.writeVariableSizeField(fieldName, FieldType.INT_ARRAY, values, ObjectDataOutput::writeIntArray);
    }

    @Override
    public void writeLongArray(@Nonnull String fieldName, @Nullable long[] values) {
        this.writeVariableSizeField(fieldName, FieldType.LONG_ARRAY, values, ObjectDataOutput::writeLongArray);
    }

    @Override
    public void writeDoubleArray(@Nonnull String fieldName, @Nullable double[] values) {
        this.writeVariableSizeField(fieldName, FieldType.DOUBLE_ARRAY, values, ObjectDataOutput::writeDoubleArray);
    }

    @Override
    public void writeFloatArray(@Nonnull String fieldName, @Nullable float[] values) {
        this.writeVariableSizeField(fieldName, FieldType.FLOAT_ARRAY, values, ObjectDataOutput::writeFloatArray);
    }

    @Override
    public void writeShortArray(@Nonnull String fieldName, @Nullable short[] values) {
        this.writeVariableSizeField(fieldName, FieldType.SHORT_ARRAY, values, ObjectDataOutput::writeShortArray);
    }

    @Override
    public void writeStringArray(@Nonnull String fieldName, @Nullable String[] values) {
        this.writeVariableSizeArray(fieldName, FieldType.UTF_ARRAY, values, ObjectDataOutput::writeString);
    }

    protected <T> void writeVariableSizeArray(@Nonnull String fieldName, FieldType fieldType, T[] values, Writer<T> writer) {
        if (values == null) {
            this.setPositionAsNull(fieldName, fieldType);
            return;
        }
        try {
            this.setPosition(fieldName, fieldType);
            int itemCount = values.length;
            this.out.writeInt(itemCount);
            int dataLengthOffset = this.out.position();
            this.out.writeZeroBytes(4);
            int offset = this.out.position();
            int[] offsets = new int[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                if (values[i] != null) {
                    offsets[i] = this.out.position() - offset;
                    writer.write(this.out, values[i]);
                    continue;
                }
                offsets[i] = -1;
            }
            int dataLength = this.out.position() - offset;
            this.out.writeInt(dataLengthOffset, dataLength);
            this.writeOffsets(dataLength, offsets);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public void writeDecimalArray(@Nonnull String fieldName, @Nullable BigDecimal[] values) {
        this.writeVariableSizeArray(fieldName, FieldType.DECIMAL_ARRAY, values, IOUtil::writeBigDecimal);
    }

    @Override
    public void writeTimeArray(@Nonnull String fieldName, @Nullable LocalTime[] values) {
        this.writeVariableSizeField(fieldName, FieldType.TIME_ARRAY, values, DefaultCompactWriter::writeLocalTimeArray0);
    }

    @Override
    public void writeDateArray(@Nonnull String fieldName, @Nullable LocalDate[] values) {
        this.writeVariableSizeField(fieldName, FieldType.DATE_ARRAY, values, DefaultCompactWriter::writeLocalDateArray0);
    }

    @Override
    public void writeTimestampArray(@Nonnull String fieldName, @Nullable LocalDateTime[] values) {
        this.writeVariableSizeField(fieldName, FieldType.TIMESTAMP_ARRAY, values, DefaultCompactWriter::writeLocalDateTimeArray0);
    }

    @Override
    public void writeTimestampWithTimezoneArray(@Nonnull String fieldName, @Nullable OffsetDateTime[] values) {
        this.writeVariableSizeField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY, values, DefaultCompactWriter::writeOffsetDateTimeArray0);
    }

    protected void setPositionAsNull(@Nonnull String fieldName, FieldType fieldType) {
        FieldDescriptor field = this.checkFieldDefinition(fieldName, fieldType);
        int index = field.getIndex();
        this.fieldOffsets[index] = -1;
    }

    protected void setPosition(@Nonnull String fieldName, FieldType fieldType) {
        FieldDescriptor field = this.checkFieldDefinition(fieldName, fieldType);
        int pos = this.out.position();
        int fieldPosition = pos - this.dataStartPosition;
        int index = field.getIndex();
        this.fieldOffsets[index] = fieldPosition;
    }

    private int getFixedSizeFieldPosition(@Nonnull String fieldName, FieldType fieldType) {
        FieldDescriptor fieldDefinition = this.checkFieldDefinition(fieldName, fieldType);
        return fieldDefinition.getOffset() + this.dataStartPosition;
    }

    protected FieldDescriptor checkFieldDefinition(@Nonnull String fieldName, FieldType fieldType) {
        FieldDescriptor field = this.schema.getField(fieldName);
        if (field == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + " for " + this.schema);
        }
        if (!field.getType().equals((Object)fieldType)) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + " for " + this.schema);
        }
        return field;
    }

    @Override
    public <T> void writeObjectArray(@Nonnull String fieldName, T[] values) {
        this.writeVariableSizeArray(fieldName, FieldType.COMPOSED_ARRAY, values, (out, val) -> this.serializer.writeObject(out, val, this.includeSchemaOnBinary));
    }

    public void writeGenericRecordArray(@Nonnull String fieldName, GenericRecord[] values) {
        this.writeVariableSizeArray(fieldName, FieldType.COMPOSED_ARRAY, values, (out, val) -> this.serializer.writeGenericRecord(out, (CompactGenericRecord)val, this.includeSchemaOnBinary));
    }

    private static void writeLocalDateArray0(ObjectDataOutput out, LocalDate[] value) throws IOException {
        out.writeInt(value.length);
        for (LocalDate localDate : value) {
            IOUtil.writeLocalDate(out, localDate);
        }
    }

    private static void writeLocalTimeArray0(ObjectDataOutput out, LocalTime[] value) throws IOException {
        out.writeInt(value.length);
        for (LocalTime localTime : value) {
            IOUtil.writeLocalTime(out, localTime);
        }
    }

    private static void writeLocalDateTimeArray0(ObjectDataOutput out, LocalDateTime[] value) throws IOException {
        out.writeInt(value.length);
        for (LocalDateTime localDateTime : value) {
            IOUtil.writeLocalDateTime(out, localDateTime);
        }
    }

    private static void writeOffsetDateTimeArray0(ObjectDataOutput out, OffsetDateTime[] value) throws IOException {
        out.writeInt(value.length);
        for (OffsetDateTime offsetDateTime : value) {
            IOUtil.writeOffsetDateTime(out, offsetDateTime);
        }
    }

    private static void writeBooleanBits(BufferObjectDataOutput out, boolean[] booleans) throws IOException {
        int len = booleans != null ? booleans.length : -1;
        out.writeInt(len);
        int position = out.position();
        if (len > 0) {
            int index = 0;
            out.writeZeroBytes(1);
            for (boolean v : booleans) {
                if (index == 8) {
                    index = 0;
                    out.writeZeroBytes(1);
                    ++position;
                }
                out.writeBooleanBit(position, index, v);
                ++index;
            }
        }
    }

    static interface Writer<T> {
        public void write(BufferObjectDataOutput var1, T var2) throws IOException;
    }
}

