/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.store;

import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.nearcache.impl.record.NearCacheDataRecord;
import com.hazelcast.internal.nearcache.impl.store.BaseHeapNearCacheRecordStore;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.JVMUtil;

public class NearCacheDataRecordStore<K, V>
extends BaseHeapNearCacheRecordStore<K, V, NearCacheDataRecord> {
    public NearCacheDataRecordStore(String name, NearCacheConfig nearCacheConfig, SerializationService serializationService, ClassLoader classLoader) {
        super(name, nearCacheConfig, serializationService, classLoader);
    }

    @Override
    protected long getKeyStorageMemoryCost(K key) {
        if (key instanceof Data) {
            return JVMUtil.REFERENCE_COST_IN_BYTES + ((Data)key).getHeapCost();
        }
        return 0L;
    }

    @Override
    protected long getRecordStorageMemoryCost(NearCacheDataRecord record) {
        if (record == null) {
            return 0L;
        }
        Data value = (Data)record.getValue();
        return JVMUtil.REFERENCE_COST_IN_BYTES + JVMUtil.REFERENCE_COST_IN_BYTES + 4 + JVMUtil.REFERENCE_COST_IN_BYTES + 16 + (value != null ? value.getHeapCost() : 0) + 16 + 20 + 1;
    }

    @Override
    protected NearCacheDataRecord createRecord(V value) {
        Data dataValue = this.toData(value);
        long creationTime = Clock.currentTimeMillis();
        if (this.timeToLiveMillis > 0L) {
            return new NearCacheDataRecord(dataValue, creationTime, creationTime + this.timeToLiveMillis);
        }
        return new NearCacheDataRecord(dataValue, creationTime, -1L);
    }

    @Override
    protected void updateRecordValue(NearCacheDataRecord record, V value) {
        record.setValue(this.toData(value));
    }
}

