/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.impl.YamlClientDomConfigProcessor;
import com.hazelcast.config.Config;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.YamlMemberDomConfigProcessor;
import com.hazelcast.internal.config.override.ConfigNode;
import com.hazelcast.internal.config.override.ConfigNodeStateTracker;
import com.hazelcast.internal.config.override.ConfigOverrideElementAdapter;
import com.hazelcast.internal.config.override.ConfigOverrideValidator;
import com.hazelcast.internal.config.override.ConfigProvider;
import com.hazelcast.internal.config.override.EnvConfigProvider;
import com.hazelcast.internal.config.override.EnvVariablesConfigParser;
import com.hazelcast.internal.config.override.PropertiesToNodeConverter;
import com.hazelcast.internal.config.override.SystemPropertiesConfigParser;
import com.hazelcast.internal.config.override.SystemPropertiesConfigProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;

public class ExternalConfigurationOverride {
    private static final ILogger LOGGER = Logger.getLogger(ExternalConfigurationOverride.class);

    public Config overwriteMemberConfig(Config config) {
        return this.overwrite(config, (provider, rootNode, target) -> {
            try {
                new YamlMemberDomConfigProcessor(true, (Config)target, false).buildConfig(new ConfigOverrideElementAdapter(rootNode));
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("failed to overwrite configuration coming from " + provider, e);
            }
        }, new EnvConfigProvider(EnvVariablesConfigParser.member()), new SystemPropertiesConfigProvider(SystemPropertiesConfigParser.member()));
    }

    public ClientConfig overwriteClientConfig(ClientConfig config) {
        return this.overwrite(config, (provider, rootNode, target) -> {
            try {
                new YamlClientDomConfigProcessor(true, (ClientConfig)target, false).buildConfig(new ConfigOverrideElementAdapter(rootNode));
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("failed to overwrite configuration coming from " + provider, e);
            }
        }, new EnvConfigProvider(EnvVariablesConfigParser.client()), new SystemPropertiesConfigProvider(SystemPropertiesConfigParser.client()));
    }

    private <T> T overwrite(T config, ConfigConsumer<T> configProcessor, ConfigProvider ... providers) {
        ConfigOverrideValidator.validate(new HashSet<ConfigProvider>(Arrays.asList(providers)));
        for (ConfigProvider configProvider : providers) {
            Map<String, String> properties = configProvider.properties();
            if (properties.isEmpty()) continue;
            ConfigNode rootNode = PropertiesToNodeConverter.propsToNode(properties);
            configProcessor.apply(configProvider.name(), rootNode, config);
            Map<String, String> unprocessed = new ConfigNodeStateTracker().unprocessedNodes(rootNode);
            LOGGER.info(String.format("Detected external configuration entries in %s: [%s]", configProvider.name(), properties.entrySet().stream().filter(e -> !unprocessed.containsKey(e.getKey())).map(e -> {
                if (((String)e.getKey()).equals("hazelcast.licensekey")) {
                    String[] licenceKeyParts = ((String)e.getValue()).split("#");
                    String originalKeyPart = licenceKeyParts[licenceKeyParts.length - 1];
                    return (String)e.getKey() + "=" + originalKeyPart.substring(0, 5) + "*********" + originalKeyPart.substring(originalKeyPart.length() - 5);
                }
                return (String)e.getKey() + "=" + (String)e.getValue();
            }).collect(Collectors.joining(","))));
            if (unprocessed.isEmpty()) continue;
            LOGGER.warning(String.format("Unrecognized %s configuration entries: %s", configProvider.name(), unprocessed.keySet()));
        }
        return config;
    }

    @FunctionalInterface
    static interface ConfigConsumer<T> {
        public void apply(String var1, ConfigNode var2, T var3);
    }
}

