/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.Config;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.operation.PrepareForPassiveClusterOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.version.Version;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class JetExtension {
    private final Node node;
    private final ILogger logger;
    private final JetServiceBackend jetServiceBackend;
    private final AtomicBoolean activated = new AtomicBoolean();
    private volatile Version startVersion;

    public JetExtension(Node node, JetServiceBackend jetServiceBackend) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        this.jetServiceBackend = jetServiceBackend;
    }

    private void checkLosslessRestartAllowed() {
        Config config = this.node.config.getStaticConfig();
        JetConfig jetConfig = config.getJetConfig();
        if (jetConfig.isLosslessRestartEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Lossless Restart requires Hazelcast Enterprise Edition");
        }
    }

    public void beforeStart() {
        this.jetServiceBackend.configureJetInternalObjects(this.node.config.getStaticConfig(), this.node.getProperties());
        this.checkLosslessRestartAllowed();
    }

    public void afterStart() {
        this.startVersion = this.node.getClusterService().getClusterVersion();
        if (!this.tryActivate() && this.node.isRunning()) {
            this.logger.info("Jet is disabled due to current cluster version being less than 5.0.");
        }
    }

    private boolean tryActivate() {
        if (this.activated.get()) {
            return true;
        }
        Version currentVersion = this.node.getClusterService().getClusterVersion();
        if (this.node.isRunning() && currentVersion.isGreaterOrEqual(Versions.V5_0) && this.activated.compareAndSet(false, true)) {
            this.jetServiceBackend.getJobCoordinationService().startScanningForJobs();
            if (this.startVersion != null && !this.startVersion.equals(currentVersion)) {
                this.logger.info("Jet is enabled after the cluster version upgrade.");
            } else {
                this.logger.info("Jet is enabled");
            }
            return true;
        }
        return this.activated.get();
    }

    public void beforeClusterStateChange(ClusterState requestedState) {
        if (!this.tryActivate() || requestedState != ClusterState.PASSIVE) {
            return;
        }
        this.logger.info("Jet is preparing to enter the PASSIVE cluster state");
        NodeEngineImpl ne = this.node.nodeEngine;
        try {
            ne.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new PrepareForPassiveClusterOperation(), ne.getMasterAddress()).invoke().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void onClusterStateChange() {
        if (this.tryActivate()) {
            this.jetServiceBackend.getJobCoordinationService().clusterChangeDone();
        }
    }

    public void onClusterVersionChange() {
        this.tryActivate();
    }

    public void beforeShutdown(boolean terminate) {
        if (!terminate && this.tryActivate()) {
            this.jetServiceBackend.shutDownJobs();
        }
    }

    public void handlePacket(Packet packet) {
        this.jetServiceBackend.handlePacket(packet);
    }

    public Map<String, Object> createExtensionServices() {
        HashMap<String, Object> extensionServices = new HashMap<String, Object>();
        extensionServices.put("hz:impl:jetService", this.jetServiceBackend);
        return extensionServices;
    }

    public JetService getJet() {
        if (this.tryActivate()) {
            return this.jetServiceBackend.getJet();
        }
        throw new IllegalArgumentException("Jet is disabled because the current cluster version is less than 5.0");
    }
}

