/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientFetchSchemaCodec;
import com.hazelcast.client.impl.protocol.codec.ClientSendAllSchemasCodec;
import com.hazelcast.client.impl.protocol.codec.ClientSendSchemaCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.logging.ILogger;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientSchemaService
implements SchemaService {
    private final Map<Long, Schema> schemas = new ConcurrentHashMap<Long, Schema>();
    private final HazelcastClientInstanceImpl client;
    private final ILogger logger;

    public ClientSchemaService(HazelcastClientInstanceImpl client, ILogger logger) {
        this.client = client;
        this.logger = logger;
    }

    @Override
    public Schema get(long schemaId) {
        ClientInvocation invocation;
        ClientMessage message;
        Schema schema = this.schemas.get(schemaId);
        if (schema != null) {
            return schema;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Could not find schema id  " + schemaId + " locally, will search on the cluster" + schemaId);
        }
        if ((schema = ClientFetchSchemaCodec.decodeResponse(message = (ClientMessage)(invocation = new ClientInvocation(this.client, ClientFetchSchemaCodec.encodeRequest(schemaId), "schema-service")).invoke().joinInternal())) != null) {
            this.schemas.put(schemaId, schema);
        }
        return schema;
    }

    @Override
    public void put(Schema schema) {
        long schemaId = schema.getSchemaId();
        Schema existingSchema = this.schemas.get(schemaId);
        if (existingSchema != null) {
            return;
        }
        ClientMessage clientMessage = ClientSendSchemaCodec.encodeRequest(schema);
        ClientInvocation invocation = new ClientInvocation(this.client, clientMessage, "schema-service");
        invocation.invoke().joinInternal();
        this.putIfAbsent(schema);
    }

    @Override
    public void putLocal(Schema schema) {
        this.putIfAbsent(schema);
    }

    private boolean putIfAbsent(Schema schema) {
        long schemaId = schema.getSchemaId();
        Schema existingSchema = this.schemas.putIfAbsent(schemaId, schema);
        if (existingSchema == null) {
            return true;
        }
        if (!schema.equals(existingSchema)) {
            throw new IllegalStateException("Schema with schemaId " + schemaId + " already exists. existing schema " + existingSchema + "new schema " + schema);
        }
        return false;
    }

    public void sendAllSchemas() {
        if (this.schemas.isEmpty()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("There is no schema to send to the cluster");
            }
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Sending schemas to the cluster " + this.schemas);
        }
        ClientMessage clientMessage = ClientSendAllSchemasCodec.encodeRequest(new ArrayList<Schema>(this.schemas.values()));
        ClientInvocation invocation = new ClientInvocation(this.client, clientMessage, "schema-service");
        invocation.invoke().joinInternal();
    }
}

