/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker.handler;

import com.openexchange.osgi.OSGiPlugin;
import com.openexchange.osgi.extension.OSGiTargetPlatformExtension;
import com.openexchange.osgi.worker.handler.ProjectHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/openexchange/osgi/worker/handler/TargetPlatformHandler;", "Lcom/openexchange/osgi/worker/handler/ProjectHandler;", "()V", "addJarsToArchives", "", "project", "Lorg/gradle/api/Project;", "jars", "", "Ljava/io/File;", "(Lorg/gradle/api/Project;[Ljava/io/File;)V", "determineBundleDirectory", "fetch", "handle", "osgi"})
public class TargetPlatformHandler
implements ProjectHandler {
    @Override
    public void handle(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Logger logger = project.getLogger();
        logger.info("OSGi-Plugin: Found target platform: {}", (Object)project.getName());
        this.fetch(project);
        Object[] objectArray = new Object[]{project};
        project.getExtensions().create("osgi", OSGiTargetPlatformExtension.class, objectArray);
        File jarsDir = this.determineBundleDirectory(project);
        File[] jars = jarsDir.listFiles(TargetPlatformHandler::handle$lambda$0);
        if (jars == null) {
            logger.debug("No JARs found for project {} in path {}", (Object)project.getName(), (Object)jarsDir.getAbsolutePath());
            return;
        }
        project.getConfigurations().maybeCreate("archives");
        this.addJarsToArchives(project, jars);
        try {
            File[] fileArray = jars;
            OSGiPlugin.Companion.getModuleDatabase().addBinaryModules(Arrays.copyOf(fileArray, fileArray.length));
        }
        catch (IOException e) {
            throw new GradleException("Unable to add JARS to the module database: " + e.getMessage(), (Throwable)e);
        }
    }

    public void fetch(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public File determineBundleDirectory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        return FilesKt.resolve((File)file, (String)"jars");
    }

    private final void addJarsToArchives(Project project, File[] jars) {
        for (File file : jars) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles(TargetPlatformHandler::addJarsToArchives$lambda$1);
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"file.listFiles { fileInD\u2026rectory\n                }");
                this.addJarsToArchives(project, fileArray);
                continue;
            }
            project.getArtifacts().add("archives", (Object)file);
            project.getLogger().info("Adding JAR {} for project {}", (Object)file, (Object)project.getName());
        }
    }

    private static final boolean handle$lambda$0(File file) {
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"jar") || file.isDirectory();
    }

    private static final boolean addJarsToArchives$lambda$1(File fileInDirectory) {
        Intrinsics.checkNotNullExpressionValue((Object)fileInDirectory, (String)"fileInDirectory");
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)fileInDirectory), (Object)"jar") || fileInDirectory.isDirectory();
    }
}

