/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker;

import com.openexchange.osgi.data.JdkExports;
import com.openexchange.osgi.data.PlatformModuleHelper;
import com.openexchange.osgi.worker.NoParameters;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.workers.WorkAction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/openexchange/osgi/worker/JdkWorker;", "Lorg/gradle/workers/WorkAction;", "Lcom/openexchange/osgi/worker/NoParameters;", "()V", "addJPMSExports", "", "addJava8ProfileExports", "execute", "osgi"})
public abstract class JdkWorker
implements WorkAction<NoParameters> {
    public void execute() {
        JavaVersion version = JavaVersion.current();
        if (version.isJava8()) {
            this.addJava8ProfileExports();
        } else {
            JavaVersion javaVersion = JavaVersion.VERSION_1_9;
            JavaVersion javaVersion2 = JavaVersion.VERSION_17;
            Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
            JavaVersion javaVersion3 = version;
            boolean bl = 0 <= javaVersion3.compareTo((Object)javaVersion) ? javaVersion3.compareTo((Object)javaVersion2) <= 0 : false;
            if (bl) {
                this.addJPMSExports();
            } else {
                throw new GradleException("Determining JDK exports is only possible for Java version 8 up to 17. Here " + version + " or " + System.getProperty("java.version"));
            }
        }
    }

    private final void addJava8ProfileExports() {
        block0: {
            Set<String> set = JdkExports.Companion.getProfiles().get(JavaVersion.VERSION_1_8);
            if (set == null) break block0;
            Set<String> it = set;
            boolean bl = false;
            JdkExports.Companion.addAll((Collection<String>)it);
        }
    }

    private final void addJPMSExports() {
        JdkExports.Companion.addAll(new PlatformModuleHelper().calculateVMPackages());
    }
}

