/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker.handler;

import com.openexchange.build.ProjectType;
import com.openexchange.osgi.worker.handler.CommandLineToolHandler;
import com.openexchange.osgi.worker.handler.ImageLayerHandler;
import com.openexchange.osgi.worker.handler.OSGiBundleHandler;
import com.openexchange.osgi.worker.handler.ProjectHandler;
import com.openexchange.osgi.worker.handler.TargetPlatformFetcherHandler;
import com.openexchange.osgi.worker.handler.TargetPlatformHandler;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/openexchange/osgi/worker/handler/ProjectHandlerRegistry;", "", "()V", "registry", "", "Lcom/openexchange/build/ProjectType;", "Lcom/openexchange/osgi/worker/handler/ProjectHandler;", "getHandler", "type", "registerHandler", "", "handler", "Companion", "osgi"})
public final class ProjectHandlerRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ProjectType, ProjectHandler> registry = new HashMap(6);
    @NotNull
    private static final ProjectHandlerRegistry instance = new ProjectHandlerRegistry();

    public ProjectHandlerRegistry() {
        this.registerHandler(ProjectType.CLT, new CommandLineToolHandler());
        this.registerHandler(ProjectType.TARGET_PLATFORM, new TargetPlatformHandler());
        this.registerHandler(ProjectType.TARGET_PLATFORM_FETCHER, new TargetPlatformFetcherHandler());
        this.registerHandler(ProjectType.BUNDLE, new OSGiBundleHandler());
        this.registerHandler(ProjectType.TEST_BUNDLE, new OSGiBundleHandler());
        this.registerHandler(ProjectType.IMAGE_LAYER, new ImageLayerHandler());
    }

    public final void registerHandler(@NotNull ProjectType type, @NotNull ProjectHandler handler) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.registry.put(type, handler);
    }

    @Nullable
    public final ProjectHandler getHandler(@NotNull ProjectType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.registry.get(type);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/openexchange/osgi/worker/handler/ProjectHandlerRegistry$Companion;", "", "()V", "instance", "Lcom/openexchange/osgi/worker/handler/ProjectHandlerRegistry;", "getInstance", "()Lcom/openexchange/osgi/worker/handler/ProjectHandlerRegistry;", "osgi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectHandlerRegistry getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

