/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker;

import com.openexchange.osgi.OSGiPlugin;
import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.BinDirModule;
import com.openexchange.osgi.data.BundleImport;
import com.openexchange.osgi.data.Classpath;
import com.openexchange.osgi.data.ModuleDatabase;
import com.openexchange.osgi.data.ModuleDependencies;
import com.openexchange.osgi.data.OSGIManifest;
import com.openexchange.osgi.worker.ResolveDependenciesWorker;
import com.openexchange.osgi.worker.WorkerParameters;
import com.openexchange.osgi.worker.handler.ProjectHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J0\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/openexchange/osgi/worker/ResolveDependenciesWorker;", "Lorg/gradle/workers/WorkAction;", "Lcom/openexchange/osgi/worker/WorkerParameters;", "()V", "execute", "", "getPackage", "", "className", "resolveCompileClasspath", "", "modules", "", "Lcom/openexchange/osgi/data/AbstractModule;", "usedPackages", "resolveJars", "project", "Lorg/gradle/api/Project;", "projectManifest", "Lcom/openexchange/osgi/data/OSGIManifest;", "resolveLocalLibraries", "implementation", "Lorg/gradle/api/artifacts/Configuration;", "apiConfiguration", "resolveProjectDependencies", "implementationConfiguration", "testImplementationConfiguration", "testRuntimeOnly", "superInterfacesOfExportedClasses", "file", "Ljava/io/File;", "osgi"})
public abstract class ResolveDependenciesWorker
implements WorkAction<WorkerParameters> {
    public void execute() {
        String projectName = (String)((WorkerParameters)this.getParameters()).getProjectName().get();
        Project project = (Project)OSGiPlugin.Companion.getProjectsPool().get(projectName);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ModuleDatabase moduleDatabase = OSGiPlugin.Companion.getModuleDatabase();
        Intrinsics.checkNotNullExpressionValue((Object)projectName, (String)"projectName");
        OSGIManifest oSGIManifest = moduleDatabase.getModule(projectName);
        if (oSGIManifest == null) {
            return;
        }
        OSGIManifest projectManifest = oSGIManifest;
        SourceSetContainer sourceSets = (SourceSetContainer)project2.getExtensions().getByType(SourceSetContainer.class);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
        Object[] objectArray = new String[]{"sim", "test"};
        testSourceSet.getJava().srcDir((Object)SetsKt.setOf((Object[])objectArray));
        Configuration apiConfiguration = project2.getConfigurations().getByName(mainSourceSet.getApiConfigurationName());
        Configuration implementationConfiguration = project2.getConfigurations().getByName(mainSourceSet.getImplementationConfigurationName());
        Configuration testImplementationConfiguration = project2.getConfigurations().getByName(testSourceSet.getImplementationConfigurationName());
        Configuration testRuntimeOnly = project2.getConfigurations().getByName(testSourceSet.getRuntimeOnlyConfigurationName());
        Intrinsics.checkNotNullExpressionValue((Object)implementationConfiguration, (String)"implementationConfiguration");
        Intrinsics.checkNotNullExpressionValue((Object)testImplementationConfiguration, (String)"testImplementationConfiguration");
        Intrinsics.checkNotNullExpressionValue((Object)testRuntimeOnly, (String)"testRuntimeOnly");
        this.resolveProjectDependencies(project2, projectManifest, implementationConfiguration, testImplementationConfiguration, testRuntimeOnly);
        Intrinsics.checkNotNullExpressionValue((Object)apiConfiguration, (String)"apiConfiguration");
        this.resolveLocalLibraries(project2, projectManifest, implementationConfiguration, apiConfiguration);
        this.resolveJars(project2, projectManifest);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"compileClasspath", (Object)mainSourceSet.getCompileClasspath()), TuplesKt.to((Object)"runtimeClasspath", (Object)mainSourceSet.getRuntimeClasspath()), TuplesKt.to((Object)"testCompileClasspath", (Object)testSourceSet.getCompileClasspath()), TuplesKt.to((Object)"testRuntimeClasspath", (Object)testSourceSet.getRuntimeClasspath())};
        OSGiPlugin.Companion.registerTasks(project2, MapsKt.mapOf((Pair[])pairArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveProjectDependencies(Project project, OSGIManifest projectManifest, Configuration implementationConfiguration, Configuration testImplementationConfiguration, Configuration testRuntimeOnly) {
        AbstractModule module;
        boolean bl;
        Collection<List<String>> collection;
        Iterable $this$map$iv;
        Collection<String> collection2;
        Object[] $this$mapTo$iv$iv;
        void $this$map$iv2;
        Iterable iterable;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv22;
        List list;
        Object relativePath;
        Object object;
        Collection destination$iv$iv;
        Set<String> classpathBinaryArtifactPaths;
        Classpath classPath;
        Object depTestOut;
        SourceSetContainer depSourceSets;
        Project depProject;
        boolean bl2;
        String it;
        ModuleDatabase moduleDatabase = OSGiPlugin.Companion.getModuleDatabase();
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        ModuleDependencies moduleDependencies2 = moduleDatabase.getModuleDependencies(string, (Function1<? super String, ? extends Project>)((Function1)new Function1<String, Project>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            @Nullable
            public final Project invoke(@NotNull String name) {
                Project found;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    found = this.$project.getRootProject().findProject(name);
                    Project project = found;
                    if (project == null || (project = project.getPluginManager()) == null) break block0;
                    project.apply(JavaLibraryPlugin.class);
                }
                return found;
            }
        }));
        Iterable $this$forEach$iv = moduleDependencies2.getProjectsForImplementation();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            bl2 = false;
            depProject = project.getRootProject().project(it);
            implementationConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)depProject));
            depSourceSets = (SourceSetContainer)depProject.getExtensions().getByType(SourceSetContainer.class);
            depTestOut = ((SourceSet)depSourceSets.getByName("test")).getOutput();
            testImplementationConfiguration.getDependencies().add((Object)project.getDependencies().create(depTestOut));
        }
        $this$forEach$iv = moduleDependencies2.getProjectsForTests();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            bl2 = false;
            depProject = project.getRootProject().project(it);
            testImplementationConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)depProject));
            depSourceSets = (SourceSetContainer)depProject.getExtensions().getByType(SourceSetContainer.class);
            depTestOut = ((SourceSet)depSourceSets.getByName("test")).getOutput();
            testImplementationConfiguration.getDependencies().add((Object)project.getDependencies().create(depTestOut));
        }
        Classpath classpath = classPath = ProjectHandler.Companion.getClasspath(project);
        Set<String> set = classpathBinaryArtifactPaths = classpath != null ? classpath.getLibs() : null;
        if (set != null) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3 = set;
            boolean $i$f$map = false;
            Iterable bl3 = $this$map$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                File file;
                String string2 = (String)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl22 = false;
                if (StringsKt.startsWith$default((String)string2, (String)"/", (boolean)false, (int)2, null)) {
                    String pathWithoutPrefix = StringsKt.removePrefix((String)string2, (CharSequence)"/");
                    String projectName = StringsKt.substringBefore$default((String)pathWithoutPrefix, (String)"/", null, (int)2, null);
                    File projectDir = project.getRootProject().project(projectName).getProjectDir();
                    relativePath = StringsKt.substringAfter$default((String)pathWithoutPrefix, (String)"/", null, (int)2, null);
                    Intrinsics.checkNotNullExpressionValue((Object)projectDir, (String)"projectDir");
                    file = FilesKt.resolve((File)projectDir, (String)relativePath);
                } else {
                    file = new File(string2);
                }
                object.add(file);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List classpathBinaryArtifacts = list;
        Iterable $i$f$map = moduleDependencies2.getBinaries();
        Set set2 = moduleDependencies2.getBinaries();
        object = this;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv22;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object e : $this$mapTo$iv$iv2) {
            void it3;
            AbstractModule bl22 = (AbstractModule)e;
            iterable = destination$iv$iv2;
            boolean bl4 = false;
            iterable.add(it3.getExportedPackages());
        }
        iterable = (List)destination$iv$iv2;
        Iterable iterable2 = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)iterable));
        Set<BundleImport> set3 = projectManifest.getImports();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"projectManifest.imports");
        $this$map$iv22 = set3;
        iterable = iterable2;
        boolean $i$f$map3 = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        Object[] destination$iv$iv3 = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo42 = false;
        for (Object e : $this$mapTo$iv$iv) {
            void it2;
            BundleImport it3 = (BundleImport)e;
            collection2 = destination$iv$iv3;
            boolean bl5 = false;
            collection2.add(it2.getPackageName());
        }
        collection2 = (List)destination$iv$iv3;
        List<String> moduleDatabaseBinaryArtifacts = super.resolveCompileClasspath(set2, CollectionsKt.intersect((Iterable)iterable, (Iterable)collection2));
        Collection binaryArtifacts = classpathBinaryArtifacts != null ? (Collection)CollectionsKt.union((Iterable)moduleDatabaseBinaryArtifacts, (Iterable)classpathBinaryArtifacts) : (Collection)moduleDatabaseBinaryArtifacts;
        $this$mapTo$iv$iv = new Object[]{binaryArtifacts};
        ConfigurableFileCollection binaryArtifactsFileCollection = project.files($this$mapTo$iv$iv);
        Dependency binaryArtifactsDependency = project.getDependencies().create((Object)binaryArtifactsFileCollection);
        implementationConfiguration.getDependencies().add((Object)binaryArtifactsDependency);
        destination$iv$iv3 = new Object[1];
        Iterable $i$f$mapTo42 = moduleDependencies2.getBinariesForTests();
        int n = 0;
        collection2 = destination$iv$iv3;
        iterable = project;
        set2 = project.getDependencies();
        object = testImplementationConfiguration.getDependencies();
        boolean $i$f$map32 = false;
        void var17_33 = $this$map$iv;
        Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : var17_33) {
            relativePath = (AbstractModule)item$iv$iv4;
            collection = destination$iv$iv32;
            bl = false;
            collection.add(module.getRequiredClasspathIncludingModule(false));
        }
        collection2[n] = collection = (List)destination$iv$iv32;
        object.add((Object)set2.create(iterable.files(destination$iv$iv3)));
        destination$iv$iv3 = new Object[1];
        $this$map$iv = moduleDependencies2.getBinariesForTests();
        n = 0;
        collection2 = destination$iv$iv3;
        iterable = project;
        set2 = project.getDependencies();
        object = testRuntimeOnly.getDependencies();
        boolean $i$f$map4 = false;
        Iterable iterable3 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : iterable3) {
            module = (AbstractModule)item$iv$iv;
            collection = destination$iv$iv4;
            bl = false;
            collection.add(module.getFullRuntimeClasspath());
        }
        collection = (List)destination$iv$iv4;
        collection2[n] = collection;
        object.add((Object)set2.create(iterable.files(destination$iv$iv3)));
        if (moduleDependencies2.getJunit4()) {
            project.getLogger().debug("Adding JUnit 4 classpath container to " + project.getName());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)"junit"), TuplesKt.to((Object)"name", (Object)"junit"), TuplesKt.to((Object)"version", (Object)"4.13.1")};
            Dependency dependency = project.getDependencies().create((Object)MapsKt.mapOf((Pair[])pairArray));
            testImplementationConfiguration.getDependencies().add((Object)dependency);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> resolveCompileClasspath(Set<? extends AbstractModule> modules, Set<String> usedPackages) {
        List retval = new ArrayList();
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            AbstractModule module = (AbstractModule)element$iv;
            boolean bl = false;
            List<String> list = module.getRequiredClasspathIncludingModule(false);
            Intrinsics.checkNotNullExpressionValue(list, (String)"module.getRequiredClasspathIncludingModule(false)");
            retval.addAll((Collection)list);
            if (module instanceof BinDirModule) continue;
            File file = module.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"module.file");
            Set<String> set = module.getExportedPackages();
            Intrinsics.checkNotNullExpressionValue(set, (String)"module.exportedPackages");
            Set<String> interfaces = this.superInterfacesOfExportedClasses(file, CollectionsKt.intersect((Iterable)set, (Iterable)usedPackages));
            Iterable $this$map$iv = interfaces;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.getPackage((String)it));
            }
            Set interfacePackages = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (!(!((Collection)interfacePackages).isEmpty())) continue;
            List<AbstractModule> list2 = module.getDependencies(false);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"module.getDependencies(false)");
            retval.addAll((Collection)this.resolveCompileClasspath(CollectionsKt.toSet((Iterable)list2), interfacePackages));
        }
        return retval;
    }

    private final Set<String> superInterfacesOfExportedClasses(File file, Set<String> usedPackages) {
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> entries = jar.entries();
        Set exportedInterfaces = new LinkedHashSet();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
            if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
            String string2 = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
            if (!usedPackages.contains(this.getPackage(string2))) continue;
            ClassReader reader = new ClassReader(jar.getInputStream(entry));
            Object[] interfaces = reader.getInterfaces();
            Intrinsics.checkNotNullExpressionValue((Object)interfaces, (String)"interfaces");
            if (interfaces.length == 0) continue;
            CollectionsKt.addAll((Collection)exportedInterfaces, (Object[])interfaces);
        }
        return exportedInterfaces;
    }

    private final String getPackage(String className) {
        String string;
        String it = string = StringsKt.replace$default((String)StringsKt.removeSuffix((String)className, (CharSequence)".class"), (char)'/', (char)'.', (boolean)false, (int)4, null);
        boolean bl = false;
        String string2 = StringsKt.contains$default((CharSequence)it, (char)'.', (boolean)false, (int)2, null) ? string : null;
        return string2 != null && (string = StringsKt.substringBeforeLast$default((String)string2, (char)'.', null, (int)2, null)) != null ? string : "";
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveLocalLibraries(Project project, OSGIManifest projectManifest, Configuration implementation, Configuration apiConfiguration) {
        Sequence entries;
        void $this$filterTo$iv$iv2;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] $this$filterTo$iv$iv3;
        Set<String> set = projectManifest.getListEntry("Bundle-ClassPath");
        Intrinsics.checkNotNullExpressionValue(set, (String)"projectManifest.getListE\u2026anifest.BUNDLE_CLASSPATH)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv3) {
            String it = (String)t;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"."))) continue;
            destination$iv$iv.add(t);
        }
        List localLibsPath = (List)destination$iv$iv;
        $this$filterTo$iv$iv3 = new Object[1];
        destination$iv$iv = localLibsPath;
        int n = 0;
        Object[] objectArray = $this$filterTo$iv$iv3;
        Object object = project;
        boolean $i$f$map232 = false;
        Iterator iterator = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = collection2;
            boolean bl32 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(StringsKt.replace$default((String)it, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
        }
        collection = (List)collection2;
        objectArray[n] = collection;
        FileCollection fileCollection = object.files($this$filterTo$iv$iv3).filter(arg_0 -> ResolveDependenciesWorker.resolveLocalLibraries$lambda$12(resolveLocalLibraries.localLibsFileCollection.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"project.files(localLibsP\u2026}).filter { it.exists() }");
        List localLibsFileCollection2 = CollectionsKt.toList((Iterable)((Iterable)fileCollection));
        Iterable $this$filter$iv2 = localLibsFileCollection2;
        boolean $i$f$filter2 = false;
        Iterable $i$f$map232 = $this$filter$iv2;
        Iterable<Object> destination$iv$iv3 = new ArrayList();
        boolean bl = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            boolean $this$any$iv22;
            File file = (File)element$iv$iv;
            boolean bl2 = false;
            try {
                boolean bl3;
                block12: {
                    void $this$any$iv22;
                    Enumeration<JarEntry> enumeration = new JarFile(file).entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"JarFile(file).entries()");
                    Iterable bl32 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)resolveLocalLibraries.exported.1.1.INSTANCE), (Function1)resolveLocalLibraries.exported.1.2.INSTANCE), (Function1)resolveLocalLibraries.exported.1.3.INSTANCE));
                    boolean $i$f$any = false;
                    if ($this$any$iv22 instanceof Collection && ((Collection)$this$any$iv22).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv22) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!projectManifest.getExports().contains(it)) continue;
                            bl3 = true;
                            break block12;
                        }
                        bl3 = false;
                    }
                }
                $this$any$iv22 = bl3;
            }
            catch (IOException e) {
                throw new GradleException("Could not read .jar file " + file.getAbsolutePath(), (Throwable)e);
            }
            if (!$this$any$iv22) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List exported2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
        Iterable $this$map$iv2 = exported2;
        boolean $i$f$map = false;
        destination$iv$iv3 = $this$map$iv2;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File bl2 = (File)item$iv$iv;
            object = collection3;
            boolean bl5 = false;
            JarFile jar = new JarFile((File)file);
            entries = jar.entries();
            Set exportedInterfaces = new LinkedHashSet();
            while (entries.hasMoreElements()) {
                ClassReader reader;
                JarEntry entry = entries.nextElement();
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                if (!StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null) || ((reader = new ClassReader(jar.getInputStream(entry))).getAccess() & 0x200) == 0) continue;
                Object[] interfaces = reader.getInterfaces();
                Intrinsics.checkNotNullExpressionValue((Object)interfaces, (String)"interfaces");
                if (interfaces.length == 0) continue;
                CollectionsKt.addAll((Collection)exportedInterfaces, (Object[])interfaces);
            }
            object.add(exportedInterfaces);
        }
        List exportedInterfaces = CollectionsKt.flatten((Iterable)((List)collection3));
        Iterable $this$filter$iv3 = CollectionsKt.minus((Iterable)localLibsFileCollection2, (Iterable)exported2);
        boolean $i$f$filter3 = false;
        Iterable iterable2 = $this$filter$iv3;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : iterable2) {
            boolean bl4;
            block13: {
                void $this$any$iv;
                File file = (File)element$iv$iv;
                boolean bl6 = false;
                Enumeration<JarEntry> enumeration = new JarFile(file).entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"JarFile(file).entries()");
                entries = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)resolveLocalLibraries.toAlsoExport.1.1.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    JarEntry it = (JarEntry)element$iv;
                    boolean bl7 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    String className = StringsKt.take((String)string, (int)(it.getName().length() - 6));
                    if (!exportedInterfaces.contains(className)) continue;
                    bl4 = true;
                    break block13;
                }
                bl4 = false;
            }
            if (!bl4) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List toAlsoExport2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv4));
        Object[] objectArray2 = new Object[]{CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)localLibsFileCollection2, (Iterable)exported2), (Iterable)toAlsoExport2)};
        Dependency internalDependency = project.getDependencies().create((Object)project.files(objectArray2));
        implementation.getDependencies().add((Object)internalDependency);
        objectArray2 = new Object[]{CollectionsKt.plus((Collection)exported2, (Iterable)toAlsoExport2)};
        apiConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)project.files(objectArray2)));
    }

    private final void resolveJars(Project project, OSGIManifest projectManifest) {
        project.getTasks().named("jar", Jar.class).configure(arg_0 -> ResolveDependenciesWorker.resolveJars$lambda$18((Function1)new Function1<Jar, Unit>(projectManifest){
            final /* synthetic */ OSGIManifest $projectManifest;
            {
                this.$projectManifest = $projectManifest;
                super(1);
            }

            public final void invoke(Jar jar) {
                jar.manifest(arg_0 -> resolveJars.1.invoke$lambda$0((Function1)new Function1<Manifest, Unit>(this.$projectManifest){
                    final /* synthetic */ OSGIManifest $projectManifest;
                    {
                        this.$projectManifest = $projectManifest;
                        super(1);
                    }

                    public final void invoke(Manifest manifest) {
                        Attributes attributes = manifest.getAttributes();
                        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"manifest.attributes");
                        Map map = (Map)attributes;
                        String string = "Class-Path";
                        Set<String> set = this.$projectManifest.getListEntry("Bundle-ClassPath");
                        Intrinsics.checkNotNullExpressionValue(set, (String)"projectManifest.getListE\u2026anifest.BUNDLE_CLASSPATH)");
                        String string2 = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                        map.put(string, string2);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private static final boolean resolveLocalLibraries$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void resolveJars$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

