/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.concurrent.lock.client.AbstractLockRequest;
import com.hazelcast.multimap.impl.MultiMapPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;
import java.security.Permission;

public class MultiMapLockRequest
extends AbstractLockRequest {
    String name;

    public MultiMapLockRequest() {
    }

    public MultiMapLockRequest(Data key, long threadId, String name) {
        super(key, threadId);
        this.name = name;
    }

    public MultiMapLockRequest(Data key, long threadId, long ttl, long timeout, String name) {
        super(key, threadId, ttl, timeout);
        this.name = name;
    }

    @Override
    protected ObjectNamespace getNamespace() {
        return new DefaultObjectNamespace("hz:impl:multiMapService", this.name);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        super.write(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        super.read(reader);
    }

    @Override
    public int getFactoryId() {
        return MultiMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "lock");
    }

    @Override
    public String getDistributedObjectType() {
        return "hz:impl:multiMapService";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

