/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.admin.plugins;

import java.io.Serializable;
import com.openexchange.admin.rmi.exceptions.AbstractAdminRmiException;

/**
 * The exception which is thrown by any bundle/plugin. So that the exception is known
 * in the admin core
 *
 * @author d7
 *
 */
public class PluginException extends AbstractAdminRmiException implements Serializable {

    /**
     * For serialization
     */
    private static final long serialVersionUID = -1327700290913950494L;

    /**
     *
     */
    public PluginException() {

    }

    /**
     * @param message
     */
    public PluginException(String message) {
        super(message);

    }

    /**
     * @param cause
     */
    public PluginException(Throwable cause) {
        super(cause);

    }

    /**
     * @param message
     * @param cause
     */
    public PluginException(String message, Throwable cause) {
        super(message, cause);
    }

}
