/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.pop3;

import com.openexchange.mail.api.MailCapabilities;


/**
 * {@link POP3Capabilities} - The POP3 capabilities.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class POP3Capabilities extends MailCapabilities {

    /**
     * Initializes a new {@link POP3Capabilities}.
     */
    public POP3Capabilities() {
        super();
    }

    @Override
    public boolean hasPermissions() {
        return false;
    }

    @Override
    public boolean hasQuota() {
        return false;
    }

    @Override
    public boolean hasSort() {
        return false;
    }

    @Override
    public boolean hasSubscription() {
        return false;
    }

    @Override
    public boolean hasThreadReferences() {
        return false;
    }

    @Override
    public boolean hasFileNameSearch() {
        return false;
    }

    @Override
    public boolean hasCustomFlag() {
        return false;
    }

}
