/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import com.eclipsesource.jaxrs.publisher.internal.ServletContainerBridge;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ResourcePublisher {
    private final ServletContainerBridge servletContainerBridge;
    private final long publishDelay;
    private final ScheduledExecutorService executor;
    private volatile ScheduledFuture<?> scheduledFuture;

    public ResourcePublisher(ServletContainerBridge servletContainerBridge, long publishDelay) {
        this(ResourcePublisher.createExecutor(), servletContainerBridge, publishDelay);
    }

    ResourcePublisher(ScheduledExecutorService executor, ServletContainerBridge servletContainerBridge, long publishDelay) {
        this.servletContainerBridge = servletContainerBridge;
        this.publishDelay = publishDelay;
        this.executor = executor;
    }

    private static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "ResourcePublisher");
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable exception) {
                        throw new IllegalStateException(exception);
                    }
                });
                return thread;
            }
        });
    }

    public void schedulePublishing() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
        this.scheduledFuture = this.executor.schedule(this.servletContainerBridge, this.publishDelay, TimeUnit.MILLISECONDS);
    }

    public void cancelPublishing() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }
}

