/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.Repository;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Project {
    private final String name;
    private final String title;
    private final String person;
    private String buildConfiguration = null;
    private boolean buildDisabled = false;
    private boolean publishDisabled = false;
    private final Set<String> disabledRepositories = new HashSet<String>();
    private final List<Repository> repositories = new ArrayList<Repository>();

    public Project(String name, String title, String person) {
        this.name = name;
        this.title = title;
        this.person = person;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPerson() {
        return this.person;
    }

    public String getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public void setBuildConfiguration(String buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public void setBuildDisabled(boolean disabled) {
        this.buildDisabled = disabled;
    }

    public boolean isBuildDisabled() {
        return this.buildDisabled;
    }

    public boolean isPublishDisabled() {
        return this.publishDisabled;
    }

    public void setPublishDisabled(boolean publishDisabled) {
        this.publishDisabled = publishDisabled;
    }

    public void addDisabledRepository(String repository) {
        this.disabledRepositories.add(repository);
    }

    public String[] getDisabledRepositories() {
        return this.disabledRepositories.toArray(new String[this.disabledRepositories.size()]);
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public Repository[] getRepositories() {
        return this.repositories.toArray(new Repository[this.repositories.size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

