/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.jmx;

import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.jmxbase.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

@ManagedObject
@Description(value="This Filter is responsible for the parsing incoming HTTP packets and serializing high level objects back into the HTTP protocol format.")
public class HttpCodecFilter
extends JmxObject {
    private final org.glassfish.grizzly.http.HttpCodecFilter httpCodecFilter;
    private final AtomicLong httpContentReceived = new AtomicLong();
    private final AtomicLong httpContentWritten = new AtomicLong();
    private final AtomicLong httpCodecErrorCount = new AtomicLong();
    private final AtomicLong contentCompressionTotalGzip = new AtomicLong();
    private final AtomicLong contentBeforeCompressionTotalGzip = new AtomicLong();
    private final AtomicLong contentCompressionTotalLzma = new AtomicLong();
    private final AtomicLong contentBeforeCompressionTotalLzma = new AtomicLong();
    private final HttpProbe probe = new JmxHttpProbe();

    public HttpCodecFilter(org.glassfish.grizzly.http.HttpCodecFilter httpCodecFilter) {
        this.httpCodecFilter = httpCodecFilter;
    }

    public String getJmxName() {
        return "HttpCodecFilter";
    }

    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.httpCodecFilter.getMonitoringConfig().addProbes((Object[])new HttpProbe[]{this.probe});
    }

    protected void onDeregister(GrizzlyJmxManager mom) {
        this.httpCodecFilter.getMonitoringConfig().removeProbes((Object[])new HttpProbe[]{this.probe});
    }

    @ManagedAttribute(id="total-bytes-received")
    @Description(value="The total number of bytes this filter has processed as part of the HTTP protocol parsing process.")
    public long getTotalContentReceived() {
        return this.httpContentReceived.get();
    }

    @ManagedAttribute(id="total-bytes-written")
    @Description(value="The total number of bytes that have been written as part of the serialization process to the HTTP protocol.")
    public long getTotalContentWritten() {
        return this.httpContentWritten.get();
    }

    @ManagedAttribute(id="http-codec-error-count")
    @Description(value="The total number of protocol errors that have occurred during either the parsing or serialization process.")
    public long getHttpCodecErrorCount() {
        return this.httpCodecErrorCount.get();
    }

    @ManagedAttribute(id="http-codec-before-gzip-compression-total")
    @Description(value="The total number of bytes before gzip compression has been applied.")
    public long getTotalBytesBeforeGzipEncoding() {
        return this.contentBeforeCompressionTotalGzip.get();
    }

    @ManagedAttribute(id="http-codec-after-gzip-compression-total")
    @Description(value="The total number of bytes after gzip compression has been applied.")
    public long getTotalBytesAfterGzipEncoding() {
        return this.contentCompressionTotalGzip.get();
    }

    @ManagedAttribute(id="http-codec-gzip-avg-compression-percent")
    @Description(value="The average gzip compression result.")
    public String getGzipCompressionRatio() {
        long l1 = this.contentBeforeCompressionTotalGzip.get();
        long l2 = this.contentCompressionTotalGzip.get();
        return this.calculateAvgCompressionPercent(l1, l2);
    }

    @ManagedAttribute(id="http-codec-before-lzma-compression-total")
    @Description(value="The total number of bytes before lzma compression has been applied.")
    public long getTotalBytesBeforeLzmaEncoding() {
        return this.contentBeforeCompressionTotalLzma.get();
    }

    @ManagedAttribute(id="http-codec-after-lzma-compression-total")
    @Description(value="The total number of bytes after lzma compression has been applied.")
    public long getTotalBytesAfterLzmaEncoding() {
        return this.contentCompressionTotalLzma.get();
    }

    @ManagedAttribute(id="http-codec-lzma-avg-compression-percent")
    @Description(value="The average lzma compression result.")
    public String getLzmaAvgCompressionPercent() {
        long l1 = this.contentBeforeCompressionTotalLzma.get();
        long l2 = this.contentCompressionTotalLzma.get();
        return this.calculateAvgCompressionPercent(l1, l2);
    }

    private String calculateAvgCompressionPercent(double original, double result) {
        double r = 100.0 - result / original * 100.0;
        return String.format("%.2f%%", r);
    }

    private final class JmxHttpProbe
    implements HttpProbe {
        private JmxHttpProbe() {
        }

        public void onDataReceivedEvent(Connection connection, Buffer buffer) {
            HttpCodecFilter.this.httpContentReceived.addAndGet(buffer.remaining());
        }

        public void onDataSentEvent(Connection connection, Buffer buffer) {
            HttpCodecFilter.this.httpContentWritten.addAndGet(buffer.remaining());
        }

        public void onErrorEvent(Connection connection, HttpPacket httpPacket, Throwable error) {
            HttpCodecFilter.this.httpCodecErrorCount.incrementAndGet();
        }

        public void onHeaderParseEvent(Connection connection, HttpHeader header, int size) {
        }

        public void onHeaderSerializeEvent(Connection connection, HttpHeader header, Buffer buffer) {
        }

        public void onContentChunkParseEvent(Connection connection, HttpContent content) {
        }

        public void onContentEncodingParseResultEvent(Connection connection, HttpHeader header, Buffer result, ContentEncoding contentEncoding) {
        }

        public void onContentChunkSerializeEvent(Connection connection, HttpContent content) {
        }

        public void onContentEncodingSerializeResultEvent(Connection connection, HttpHeader header, Buffer result, ContentEncoding contentEncoding) {
            String name = contentEncoding.getName();
            if ("gzip".equals(name)) {
                HttpCodecFilter.this.contentCompressionTotalGzip.addAndGet(result.remaining());
            } else if ("lzma".equals(name)) {
                HttpCodecFilter.this.contentCompressionTotalLzma.addAndGet(result.remaining());
            }
        }

        public void onContentEncodingParseEvent(Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        }

        public void onContentEncodingSerializeEvent(Connection connection, HttpHeader header, Buffer result, ContentEncoding contentEncoding) {
            String name = contentEncoding.getName();
            if ("gzip".equals(name)) {
                HttpCodecFilter.this.contentBeforeCompressionTotalGzip.addAndGet(result.remaining());
            } else if ("lzma".equals(name)) {
                HttpCodecFilter.this.contentBeforeCompressionTotalLzma.addAndGet(result.remaining());
            }
        }

        public void onTransferEncodingParseEvent(Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        }

        public void onTransferEncodingSerializeEvent(Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        }
    }
}

