/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool.jmx;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.jmxbase.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

@ManagedObject
@Description(value="Grizzly ThreadPool (typically shared between Transport instances).")
public class ThreadPool
extends JmxObject {
    private final AbstractThreadPool threadPool;
    private final ThreadPoolProbe probe = new JmxThreadPoolProbe();
    private final AtomicInteger totalAllocatedThreadCount = new AtomicInteger();
    private final AtomicInteger busyThreadsCount = new AtomicInteger();
    private final AtomicLong totalCompletedTasksCount = new AtomicLong();
    private final AtomicInteger totalTaskQueueOverflowCount = new AtomicInteger();

    public ThreadPool(AbstractThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public String getJmxName() {
        return this.threadPool.getConfig().getPoolName();
    }

    @Override
    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.threadPool.getMonitoringConfig().addProbes((Object[])new ThreadPoolProbe[]{this.probe});
        this.totalAllocatedThreadCount.set(this.threadPool.getSize());
    }

    @Override
    protected void onDeregister(GrizzlyJmxManager mom) {
        this.threadPool.getMonitoringConfig().removeProbes((Object[])new ThreadPoolProbe[]{this.probe});
    }

    @ManagedAttribute(id="thread-pool-type")
    @Description(value="The Java type of the thread pool implementation being used.")
    public String getPoolType() {
        return this.threadPool.getClass().getName();
    }

    @ManagedAttribute(id="thread-pool-started")
    @Description(value="Indiciates whether or not the thread pool has been started.")
    public boolean isStarted() {
        return !this.threadPool.isShutdown();
    }

    @ManagedAttribute(id="thread-pool-max-num-threads")
    @Description(value="The maximum number of the threads allowed by this thread pool.")
    public int getMaxAllowedThreads() {
        return this.threadPool.getConfig().getMaxPoolSize();
    }

    @ManagedAttribute(id="thread-pool-core-pool-size")
    @Description(value="The initial/minimum number of threads managed by this thread pool.")
    public int getCorePoolSize() {
        return this.threadPool.getConfig().getCorePoolSize();
    }

    @ManagedAttribute(id="thread-pool-allocated-thread-count")
    @Description(value="The current number of threads managed by this thread pool.")
    public int getCurrentAllocatedThreadCount() {
        return this.threadPool.getSize();
    }

    @ManagedAttribute(id="thread-pool-total-allocated-thread-count")
    @Description(value="The total number of threads allocated during the lifetime of this thread pool.")
    public int getTotalAllocatedThreadCount() {
        return this.totalAllocatedThreadCount.get();
    }

    @ManagedAttribute(id="thread-pool-busy-thread-count")
    @Description(value="The number of threads, which are currently busy processing the tasks.")
    public int getBusyThreadCount() {
        return this.busyThreadsCount.get();
    }

    @ManagedAttribute(id="thread-pool-queued-task-count")
    @Description(value="The number of tasks currently being queued by this thread pool.")
    public int getCurrentTaskCount() {
        return this.threadPool.getQueue().size();
    }

    @ManagedAttribute(id="thread-pool-total-completed-tasks-count")
    @Description(value="The total number of tasks that have been processed by this thread pool.")
    public long getTotalCompletedTasksCount() {
        return this.totalCompletedTasksCount.get();
    }

    @ManagedAttribute(id="thread-pool-task-queue-overflow-count")
    @Description(value="The total number of times the task queue of this thread pool has been saturated.")
    public int getTotalTaskQueueOverflowCount() {
        return this.totalTaskQueueOverflowCount.get();
    }

    private final class JmxThreadPoolProbe
    extends ThreadPoolProbe.Adapter {
        private JmxThreadPoolProbe() {
        }

        public void onThreadAllocateEvent(AbstractThreadPool threadPool, Thread thread) {
            ThreadPool.this.totalAllocatedThreadCount.incrementAndGet();
        }

        public void onTaskDequeueEvent(AbstractThreadPool threadPool, Runnable task) {
            ThreadPool.this.busyThreadsCount.incrementAndGet();
        }

        public void onTaskCancelEvent(AbstractThreadPool threadPool, Runnable task) {
            this.decBusyThreadCount();
        }

        public void onTaskCompleteEvent(AbstractThreadPool threadPool, Runnable task) {
            ThreadPool.this.totalCompletedTasksCount.incrementAndGet();
            this.decBusyThreadCount();
        }

        public void onTaskQueueOverflowEvent(AbstractThreadPool threadPool) {
            ThreadPool.this.totalTaskQueueOverflowCount.incrementAndGet();
        }

        private void decBusyThreadCount() {
            int val = ThreadPool.this.busyThreadsCount.decrementAndGet();
            if (val < 0) {
                ThreadPool.this.busyThreadsCount.compareAndSet(val, 0);
            }
        }
    }
}

