/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.build.utils.Tools;
import com.openexchange.obs.api.BuildServiceException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public enum Architecture {
    i586,
    ppc64,
    x86_64;


    public static final Architecture parse(String arch) throws BuildServiceException {
        for (Architecture test : Architecture.values()) {
            if (!test.name().equals(arch)) continue;
            return test;
        }
        throw new BuildServiceException("Unknown architecture: \"" + arch + "\".");
    }

    public static final Collection<Architecture> parseArchitecture(String arch) throws BuildServiceException {
        return Architecture.parseArchitectureSet(arch);
    }

    public static final Collection<Architecture> parseArchitectureSet(String arch) throws BuildServiceException {
        if (arch == null || arch.isEmpty()) {
            return Collections.emptyList();
        }
        return Architecture.parseArchitecture(Tools.split((String)arch, (char)','));
    }

    public static final Collection<Architecture> parseArchitecture(Collection<String> arch) throws BuildServiceException {
        HashSet<Architecture> retval = new HashSet<Architecture>();
        for (String toTest : arch) {
            retval.add(Architecture.parse(toTest));
        }
        return retval;
    }
}

