/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializerHook;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.BinaryOperationFactory;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.spi.impl.eventservice.impl.EventPacket;
import com.hazelcast.spi.impl.operationservice.impl.operations.Backup;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionIteratingOperation;
import com.hazelcast.spi.impl.operationservice.impl.responses.BackupResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;

public final class SpiDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.spi", -1);
    public static final int NORMAL_RESPONSE = 0;
    public static final int BACKUP = 1;
    public static final int BACKUP_RESPONSE = 2;
    public static final int PARTITION_ITERATOR = 3;
    public static final int PARTITION_RESPONSE = 4;
    public static final int PARALLEL_OPERATION_FACTORY = 5;
    public static final int EVENT_PACKET = 6;
    public static final int COLLECTION = 7;
    public static final int CALL_TIMEOUT_RESPONSE = 8;
    public static final int ERROR_RESPONSE = 9;

    @Override
    public DataSerializableFactory createFactory() {
        return new DataSerializableFactory(){

            @Override
            public IdentifiedDataSerializable create(int typeId) {
                switch (typeId) {
                    case 0: {
                        return new NormalResponse();
                    }
                    case 1: {
                        return new Backup();
                    }
                    case 2: {
                        return new BackupResponse();
                    }
                    case 3: {
                        return new PartitionIteratingOperation();
                    }
                    case 4: {
                        return new PartitionIteratingOperation.PartitionResponse();
                    }
                    case 5: {
                        return new BinaryOperationFactory();
                    }
                    case 6: {
                        return new EventPacket();
                    }
                    case 7: {
                        return new SerializableCollection();
                    }
                    case 8: {
                        return new CallTimeoutResponse();
                    }
                    case 9: {
                        return new ErrorResponse();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public int getFactoryId() {
        return F_ID;
    }
}

