/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class SystemLogRecord
implements Comparable<SystemLogRecord>,
DataSerializable {
    private long date;
    private String node;
    private String message;
    private String type;

    public SystemLogRecord() {
    }

    public SystemLogRecord(long date, String message, String type) {
        this.date = date;
        this.message = message;
        this.type = type;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int compareTo(SystemLogRecord o) {
        long thisVal = this.date;
        long anotherVal = o.getDate();
        if (thisVal < anotherVal) {
            return -1;
        }
        return thisVal == anotherVal ? 0 : 1;
    }

    public int hashCode() {
        return (int)(this.date ^ this.date >>> 32);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof SystemLogRecord) {
            return this.compareTo((SystemLogRecord)o) == 0;
        }
        return false;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.date);
        out.writeUTF(this.message);
        out.writeUTF(this.type);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.date = in.readLong();
        this.message = in.readUTF();
        this.type = in.readUTF();
    }

    public String toString() {
        return "SystemLogRecord{date=" + this.date + ", node='" + this.node + '\'' + ", message='" + this.message + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

