/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class DelegateAndSkipOnConcurrentExecutionDecorator
implements Runnable {
    private final AtomicBoolean isAlreadyRunning = new AtomicBoolean();
    private final Runnable runnable;
    private final Executor executor;

    public DelegateAndSkipOnConcurrentExecutionDecorator(Runnable runnable, Executor executor) {
        this.runnable = new DelegateDecorator(runnable);
        this.executor = executor;
    }

    @Override
    public void run() {
        if (this.isAlreadyRunning.compareAndSet(false, true)) {
            this.executor.execute(this.runnable);
        }
    }

    public String toString() {
        return "DelegateAndSkipOnConcurrentExecutionDecorator{isAlreadyRunning=" + this.isAlreadyRunning + ", runnable=" + this.runnable + ", executor=" + this.executor + '}';
    }

    private class DelegateDecorator
    implements Runnable {
        private final Runnable runnable;

        DelegateDecorator(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                DelegateAndSkipOnConcurrentExecutionDecorator.this.isAlreadyRunning.set(false);
            }
        }

        public String toString() {
            return "DelegateDecorator{runnable=" + this.runnable + '}';
        }
    }
}

