/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.admin.console;

import java.text.MessageFormat;

/**
 * {@link CLIUnknownSuboptionException} - Indicates an unknown sub-option.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class CLIUnknownSuboptionException extends CLIUnknownOptionException {

    private static final long serialVersionUID = 4798934535116123584L;

    private final char suboption;

    CLIUnknownSuboptionException(final String option, final char suboption) {
        super(option, MessageFormat.format("Illegal option: ``{0}'' in ``{1}''", Character.valueOf(suboption), option));
        this.suboption = suboption;
    }

    /**
     * Gets the unknown sub-option.
     *
     * @return The unknown sub-option
     */
    public char getSuboption() {
        return suboption;
    }

}
