/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fernandospr.wns.client;

import ar.com.fernandospr.wns.model.WnsAbstractNotification;
import ar.com.fernandospr.wns.model.WnsNotificationRequestOptional;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;

public abstract class WnsResourceBuilder {
    public Invocation.Builder build(WebTarget target, WnsAbstractNotification notification, String token, WnsNotificationRequestOptional optional) {
        Invocation.Builder webResourceBuilder = target.request();
        this.addRequiredHeaders(webResourceBuilder, notification.getType(), token);
        this.addOptionalHeaders(webResourceBuilder, optional);
        return webResourceBuilder;
    }

    protected abstract Object getEntityToSendWithNotification(WnsAbstractNotification var1);

    protected void addOptionalHeaders(Invocation.Builder webResourceBuilder, WnsNotificationRequestOptional optional) {
        if (optional != null) {
            if (!this.emptyString(optional.cachePolicy)) {
                webResourceBuilder.header("X-WNS-Cache-Policy", (Object)optional.cachePolicy);
            }
            if (!this.emptyString(optional.requestForStatus)) {
                webResourceBuilder.header("X-WNS-RequestForStatus", (Object)optional.requestForStatus);
            }
            if (!this.emptyString(optional.tag)) {
                webResourceBuilder.header("X-WNS-Tag", (Object)optional.tag);
            }
            if (!this.emptyString(optional.ttl)) {
                webResourceBuilder.header("X-WNS-TTL", (Object)optional.ttl);
            }
        }
    }

    protected void addRequiredHeaders(Invocation.Builder webResourceBuilder, String type, String accessToken) {
        if (type.equalsIgnoreCase("wns/raw")) {
            webResourceBuilder.accept(new String[]{"application/octet-stream"});
        } else {
            webResourceBuilder.accept(new String[]{"text/xml"});
        }
        webResourceBuilder.header("X-WNS-Type", (Object)type).header("Authorization", (Object)("Bearer " + accessToken));
    }

    private boolean emptyString(String str) {
        return str == null || str.isEmpty();
    }
}

