/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.hazelcast.ssl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * {@link HazelcastSSLConstants} - Constants for Hazelcast SSL stuff.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.10.6
 */
public class HazelcastSSLConstants {

    /**
     * Initializes a new {@link HazelcastSSLConstants}.
     */
    private HazelcastSSLConstants() {
        super();
    }

    /**
     * Property name for Hazelcast SSL protocols. Default is: <code>"TLS,TLSv1,TLSv1.1,TLSv1.2"</code>
     */
    public static final String PROP_SSL_PROTOCOLS = "com.openexchange.hazelcast.network.ssl.protocols";

    // -------------------------------------------------------------------------------------------------------------------------------------

    /**
     * Property name for Hazelcast SSL trust store location.
     */
    public static final String PROP_TRUST_STORE = "com.openexchange.hazelcast.network.ssl.trustStore";

    /**
     * Property name for Hazelcast SSL trust store password.
     */
    public static final String PROP_TRUST_PASSWORD = "com.openexchange.hazelcast.network.ssl.trustStorePassword";

    /**
     * Property name for Hazelcast SSL trust store type. (optional)
     */
    public static final String PROP_TRUST_TYPE = "com.openexchange.hazelcast.network.ssl.trustStoreType";

    /**
     * Property name for Hazelcast SSL trust store algorithm. Default is <code>javax.net.ssl.TrustManagerFactory.getDefaultAlgorithm()</code>.
     */
    public static final String PROP_TRUST_ALGORITHM = "com.openexchange.hazelcast.network.ssl.trustManagerAlgorithm";

    // -------------------------------------------------------------------------------------------------------------------------------------

    /**
     * Property name for Hazelcast SSL key store location.
     */
    public static final String PROP_KEY_STORE = "com.openexchange.hazelcast.network.ssl.keyStore";

    /**
     * Property name for Hazelcast SSL key store location.
     */
    public static final String PROP_KEY_PASSWORD = "com.openexchange.hazelcast.network.ssl.keyStorePassword";

    /**
     * Property name for Hazelcast SSL key store type. (optional)
     */
    public static final String PROP_KEY_TYPE = "com.openexchange.hazelcast.network.ssl.keyStoreType";

    /**
     * Property name for Hazelcast SSL key store algorithm. Default is <code>javax.net.ssl.TrustManagerFactory.getDefaultAlgorithm()</code>.
     */
    public static final String PROP_KEY_ALGORITHM = "com.openexchange.hazelcast.network.ssl.keyManagerAlgorithm";

    // -------------------------------------------------------------------------------------------------------------------------------------

    private static final List<String> SSL_PROPERTY_NAMES = Arrays.asList(
        PROP_SSL_PROTOCOLS,
        PROP_TRUST_STORE,
        PROP_TRUST_PASSWORD,
        PROP_TRUST_TYPE,
        PROP_TRUST_ALGORITHM,
        PROP_KEY_STORE,
        PROP_KEY_PASSWORD,
        PROP_KEY_TYPE,
        PROP_KEY_ALGORITHM);

    /**
     * Gets the names of relevant Hazelcast SSL properties.
     *
     * @return The Hazelcast SSL property names
     */
    public static Collection<String> getSslPropertyNames() {
        return SSL_PROPERTY_NAMES;
    }

}
