/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.microsoft.graph.api.client;

import com.openexchange.rest.client.v2.RESTEndPoint;

/**
 * {@link MicrosoftGraphRESTEndPoint}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 * @since v7.10.2
 */
public enum MicrosoftGraphRESTEndPoint implements RESTEndPoint {

    /**
     * @see <a href="https://developer.microsoft.com/en-us/graph/docs/api-reference/v1.0/resources/contact">Contact Resource</a>
     */
    contacts,
    /**
     * @see <a href="https://developer.microsoft.com/en-us/graph/docs/api-reference/v1.0/resources/onedrive">OneDrive Resource</a>
     */
    drive;

    @Override
    public String getEndPoint() {
        return name();
    }
}
