/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.messaging.generic.internal;

import com.openexchange.session.Session;


/**
 * {@link GenericProperty}
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class GenericProperty {

    public final int confId;

    public final String propertyName;

    public final Session session;

    public final String serviceId;

    public final int id;

    /**
     * Initializes a new {@link GenericProperty}.
     */
    public GenericProperty(final int confId, final String propertyName, final String serviceId, final int id, final Session session) {
        super();
        this.confId = confId;
        this.propertyName = propertyName;
        this.session = session;
        this.serviceId = serviceId;
        this.id = id;
    }

}
