/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type;

import com.hazelcast.sql.SqlColumnType;

public enum QueryDataTypeFamily {
    NULL(1, 0, SqlColumnType.NULL),
    VARCHAR(56, 100, SqlColumnType.VARCHAR),
    BOOLEAN(1, 200, SqlColumnType.BOOLEAN),
    TINYINT(1, 300, SqlColumnType.TINYINT),
    SMALLINT(2, 400, SqlColumnType.SMALLINT),
    INTEGER(4, 500, SqlColumnType.INTEGER),
    BIGINT(8, 600, SqlColumnType.BIGINT),
    DECIMAL(112, 700, SqlColumnType.DECIMAL),
    REAL(4, 800, SqlColumnType.REAL),
    DOUBLE(8, 900, SqlColumnType.DOUBLE),
    TIME(24, 1000, SqlColumnType.TIME),
    DATE(24, 1100, SqlColumnType.DATE),
    TIMESTAMP(72, 1200, SqlColumnType.TIMESTAMP),
    TIMESTAMP_WITH_TIME_ZONE(168, 1300, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE),
    OBJECT(48, 1400, SqlColumnType.OBJECT),
    INTERVAL_YEAR_MONTH(16, 10, null),
    INTERVAL_DAY_SECOND(24, 20, null),
    MAP(48, 30, null);

    private final int estimatedSize;
    private final int precedence;
    private final SqlColumnType publicType;

    private QueryDataTypeFamily(int estimatedSize, int precedence, SqlColumnType publicType) {
        this.estimatedSize = estimatedSize;
        this.precedence = precedence;
        this.publicType = publicType;
    }

    public boolean isNumeric() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumericInteger() {
        switch (this) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumericApproximate() {
        switch (this) {
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isTemporal() {
        switch (this) {
            case TIME: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                return true;
            }
        }
        return false;
    }

    public boolean isObject() {
        return this == OBJECT;
    }

    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public SqlColumnType getPublicType() {
        return this.publicType;
    }

    public String toString() {
        return this.name().replace('_', ' ');
    }
}

