/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractMapTable
extends Table {
    private final String mapName;
    private final QueryTargetDescriptor keyDescriptor;
    private final QueryTargetDescriptor valueDescriptor;
    private final Object keyJetMetadata;
    private final Object valueJetMetadata;
    private final QueryException exception;

    protected AbstractMapTable(String schemaName, String sqlName, String mapName, List<TableField> fields, TableStatistics statistics, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Object keyJetMetadata, Object valueJetMetadata) {
        super(schemaName, sqlName, fields, statistics);
        this.mapName = Objects.requireNonNull(mapName);
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.keyJetMetadata = keyJetMetadata;
        this.valueJetMetadata = valueJetMetadata;
        this.exception = null;
    }

    protected AbstractMapTable(String schemaName, String name, QueryException exception) {
        super(schemaName, name, Collections.emptyList(), new ConstantTableStatistics(0L));
        this.mapName = name;
        this.keyDescriptor = null;
        this.valueDescriptor = null;
        this.keyJetMetadata = null;
        this.valueJetMetadata = null;
        this.exception = exception;
    }

    @Nonnull
    public String getMapName() {
        return this.mapName;
    }

    @Override
    public int getFieldCount() {
        this.checkException();
        return super.getFieldCount();
    }

    @Override
    public <T extends TableField> T getField(int index) {
        this.checkException();
        return super.getField(index);
    }

    protected boolean isValid() {
        return this.exception == null;
    }

    public QueryTargetDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public QueryTargetDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    public Object getKeyJetMetadata() {
        return this.keyJetMetadata;
    }

    public Object getValueJetMetadata() {
        return this.valueJetMetadata;
    }

    public QueryException getException() {
        return this.exception;
    }

    protected void checkException() {
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

