/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class RabinFingerprint {
    private static final long INIT = -4513414715797952619L;
    private static final long[] FP_TABLE = new long[256];

    private RabinFingerprint() {
    }

    public static long fingerprint64(Schema schema) {
        long fingerPrint = RabinFingerprint.fingerprint64(-4513414715797952619L, schema.getTypeName());
        fingerPrint = RabinFingerprint.fingerprint64(fingerPrint, schema.getFieldCount());
        for (FieldDescriptor descriptor : schema.getFields()) {
            fingerPrint = RabinFingerprint.fingerprint64(fingerPrint, descriptor.getFieldName());
            fingerPrint = RabinFingerprint.fingerprint64(fingerPrint, descriptor.getType().getId());
        }
        return fingerPrint;
    }

    static long fingerprint64(byte[] buf) {
        long fp = -4513414715797952619L;
        for (byte b : buf) {
            fp = RabinFingerprint.fingerprint64(fp, b);
        }
        return fp;
    }

    private static long fingerprint64(long fp, byte b) {
        return fp >>> 8 ^ FP_TABLE[(int)(fp ^ (long)b) & 0xFF];
    }

    private static long fingerprint64(long fp, @Nullable String value) {
        if (value == null) {
            return RabinFingerprint.fingerprint64(fp, -1);
        }
        byte[] utf8Bytes = value.getBytes(StandardCharsets.UTF_8);
        fp = RabinFingerprint.fingerprint64(fp, utf8Bytes.length);
        for (byte utf8Byte : utf8Bytes) {
            fp = RabinFingerprint.fingerprint64(fp, utf8Byte);
        }
        return fp;
    }

    private static long fingerprint64(long fp, int v) {
        fp = RabinFingerprint.fingerprint64(fp, (byte)(v & 0xFF));
        fp = RabinFingerprint.fingerprint64(fp, (byte)(v >>> 8 & 0xFF));
        fp = RabinFingerprint.fingerprint64(fp, (byte)(v >>> 16 & 0xFF));
        fp = RabinFingerprint.fingerprint64(fp, (byte)(v >>> 24 & 0xFF));
        return fp;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long fp = i;
            for (int j = 0; j < 8; ++j) {
                fp = fp >>> 1 ^ 0xC15D213AA4D7A795L & -(fp & 1L);
            }
            RabinFingerprint.FP_TABLE[i] = fp;
        }
    }
}

