/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.security.IdentityConfig;
import com.hazelcast.config.security.StaticCredentialsFactory;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.ICredentialsFactory;
import java.util.Objects;

public class CredentialsIdentityConfig
implements IdentityConfig {
    private final Credentials credentials;

    public CredentialsIdentityConfig(Credentials credentials) {
        this.credentials = Objects.requireNonNull(credentials);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public IdentityConfig copy() {
        return new CredentialsIdentityConfig(this.credentials);
    }

    @Override
    public ICredentialsFactory asCredentialsFactory(ClassLoader cl) {
        return new StaticCredentialsFactory(this.credentials);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CredentialsIdentityConfig [credentials=").append(this.credentials).append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.credentials);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CredentialsIdentityConfig other = (CredentialsIdentityConfig)obj;
        return Objects.equals(this.credentials, other.credentials);
    }
}

