/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AwsCredentials;
import com.hazelcast.aws.AwsRequestUtils;
import com.hazelcast.internal.util.QuickMath;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class AwsRequestSigner {
    private static final String SIGNATURE_METHOD_V4 = "AWS4-HMAC-SHA256";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final int TIMESTAMP_FIELD_LENGTH = 8;
    private final String region;
    private final String service;

    AwsRequestSigner(String region, String service) {
        this.region = region;
        this.service = service;
    }

    String authHeader(Map<String, String> attributes, Map<String, String> headers, String body, AwsCredentials credentials, String timestamp, String httpMethod) {
        return this.buildAuthHeader(credentials.getAccessKey(), this.credentialScopeEcs(timestamp), this.signedHeaders(headers), this.sign(attributes, headers, body, credentials, timestamp, httpMethod));
    }

    private String buildAuthHeader(String accessKey, String credentialScope, String signedHeaders, String signature) {
        return String.format("%s Credential=%s/%s, SignedHeaders=%s, Signature=%s", SIGNATURE_METHOD_V4, accessKey, credentialScope, signedHeaders, signature);
    }

    private String credentialScopeEcs(String timestamp) {
        return String.format("%s/%s/%s/%s", AwsRequestSigner.datestamp(timestamp), this.region, this.service, "aws4_request");
    }

    private String sign(Map<String, String> attributes, Map<String, String> headers, String body, AwsCredentials credentials, String timestamp, String httpMethod) {
        String canonicalRequest = this.canonicalRequest(attributes, headers, body, httpMethod);
        String stringToSign = this.stringToSign(canonicalRequest, timestamp);
        byte[] signingKey = this.signingKey(credentials, timestamp);
        return this.createSignature(stringToSign, signingKey);
    }

    private String canonicalRequest(Map<String, String> attributes, Map<String, String> headers, String body, String httpMethod) {
        return String.format("%s\n/\n%s\n%s\n%s\n%s", httpMethod, AwsRequestUtils.canonicalQueryString(attributes), this.canonicalHeaders(headers), this.signedHeaders(headers), AwsRequestSigner.sha256Hashhex(body));
    }

    private String canonicalHeaders(Map<String, String> headers) {
        StringBuilder canonical = new StringBuilder();
        for (Map.Entry<String, String> entry : this.sortedLowercase(headers).entrySet()) {
            canonical.append(String.format("%s:%s\n", entry.getKey(), entry.getValue()));
        }
        return canonical.toString();
    }

    private String stringToSign(String canonicalRequest, String timestamp) {
        return String.format("%s\n%s\n%s\n%s", SIGNATURE_METHOD_V4, timestamp, this.credentialScope(timestamp), AwsRequestSigner.sha256Hashhex(canonicalRequest));
    }

    private String credentialScope(String timestamp) {
        return String.format("%s/%s/%s/%s", AwsRequestSigner.datestamp(timestamp), this.region, this.service, "aws4_request");
    }

    private byte[] signingKey(AwsCredentials credentials, String timestamp) {
        String signKey = credentials.getSecretKey();
        try {
            String key = "AWS4" + signKey;
            Mac mDate = Mac.getInstance(HMAC_SHA256);
            SecretKeySpec skDate = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), HMAC_SHA256);
            mDate.init(skDate);
            byte[] kDate = mDate.doFinal(AwsRequestSigner.datestamp(timestamp).getBytes(StandardCharsets.UTF_8));
            Mac mRegion = Mac.getInstance(HMAC_SHA256);
            SecretKeySpec skRegion = new SecretKeySpec(kDate, HMAC_SHA256);
            mRegion.init(skRegion);
            byte[] kRegion = mRegion.doFinal(this.region.getBytes(StandardCharsets.UTF_8));
            Mac mService = Mac.getInstance(HMAC_SHA256);
            SecretKeySpec skService = new SecretKeySpec(kRegion, HMAC_SHA256);
            mService.init(skService);
            byte[] kService = mService.doFinal(this.service.getBytes(StandardCharsets.UTF_8));
            Mac mSigning = Mac.getInstance(HMAC_SHA256);
            SecretKeySpec skSigning = new SecretKeySpec(kService, HMAC_SHA256);
            mSigning.init(skSigning);
            return mSigning.doFinal("aws4_request".getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    private String createSignature(String stringToSign, byte[] signingKey) {
        try {
            Mac signMac = Mac.getInstance(HMAC_SHA256);
            SecretKeySpec signKS = new SecretKeySpec(signingKey, HMAC_SHA256);
            signMac.init(signKS);
            byte[] signature = signMac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            return QuickMath.bytesToHex(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String datestamp(String timestamp) {
        return timestamp.substring(0, 8);
    }

    private String signedHeaders(Map<String, String> headers) {
        return String.join((CharSequence)";", this.sortedLowercase(headers).keySet());
    }

    private Map<String, String> sortedLowercase(Map<String, String> headers) {
        TreeMap<String, String> sortedHeaders = new TreeMap<String, String>();
        for (Map.Entry<String, String> e : headers.entrySet()) {
            sortedHeaders.put(e.getKey().toLowerCase(), e.getValue());
        }
        return sortedHeaders;
    }

    private static String sha256Hashhex(String in) {
        String payloadHash;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(in.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            payloadHash = QuickMath.bytesToHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return payloadHash;
    }
}

