/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.list;

import com.hazelcast.collection.LocalListStats;
import com.hazelcast.collection.impl.collection.CollectionContainer;
import com.hazelcast.collection.impl.collection.CollectionService;
import com.hazelcast.collection.impl.list.ListContainer;
import com.hazelcast.collection.impl.list.ListProxyImpl;
import com.hazelcast.collection.impl.list.operations.ListReplicationOperation;
import com.hazelcast.collection.impl.txnlist.TransactionalListProxy;
import com.hazelcast.config.ListConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.impl.ProviderHelper;
import com.hazelcast.internal.monitor.impl.LocalListStatsImpl;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.transaction.impl.Transaction;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ListService
extends CollectionService
implements DynamicMetricsProvider,
StatisticsAwareService<LocalListStats> {
    public static final String SERVICE_NAME = "hz:impl:listService";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<String, ListContainer> containerMap = new ConcurrentHashMap<String, ListContainer>();
    private final ConcurrentMap<String, Object> splitBrainProtectionConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory splitBrainProtectionConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> splitBrainProtectionConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            ListConfig lockConfig = ListService.this.nodeEngine.getConfig().findListConfig(name);
            String splitBrainProtectionName = lockConfig.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
        }
    };
    private final ConcurrentMap<String, LocalListStatsImpl> statsMap = new ConcurrentHashMap<String, LocalListStatsImpl>();
    private final ConstructorFunction<String, LocalListStatsImpl> localCollectionStatsConstructorFunction = key -> new LocalListStatsImpl();

    public ListService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
        super.init(nodeEngine, properties);
    }

    @Override
    public ListContainer getOrCreateContainer(String name, boolean backup) {
        ListContainer current;
        ListContainer container = (ListContainer)this.containerMap.get(name);
        if (container == null && (current = this.containerMap.putIfAbsent(name, container = new ListContainer(name, this.nodeEngine))) != null) {
            container = current;
        }
        return container;
    }

    @Override
    public ConcurrentMap<String, ? extends CollectionContainer> getContainerMap() {
        return this.containerMap;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public DistributedObject createDistributedObject(String objectId, UUID source, boolean local) {
        return new ListProxyImpl(objectId, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        super.destroyDistributedObject(name);
        this.splitBrainProtectionConfigCache.remove(name);
    }

    public TransactionalListProxy createTransactionalObject(String name, Transaction transaction) {
        return new TransactionalListProxy(name, transaction, this.nodeEngine, this);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        Map<String, CollectionContainer> migrationData = this.getMigrationData(event);
        return migrationData.isEmpty() ? null : new ListReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        Object splitBrainProtectionName = ConcurrencyUtil.getOrPutSynchronized(this.splitBrainProtectionConfigCache, name, this.splitBrainProtectionConfigCacheMutexFactory, this.splitBrainProtectionConfigConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        ProviderHelper.provide(descriptor, context, "list", this.getStats());
    }

    @Override
    public Map<String, LocalListStats> getStats() {
        Map<String, LocalListStats> listStats = MapUtil.createHashMap(this.containerMap.size());
        for (Map.Entry entry : this.containerMap.entrySet()) {
            String name = (String)entry.getKey();
            ListContainer listContainer = (ListContainer)entry.getValue();
            if (!listContainer.getConfig().isStatisticsEnabled()) continue;
            LocalListStatsImpl listStat = this.getLocalCollectionStats(name);
            listStats.put(name, listStat);
        }
        return listStats;
    }

    @Override
    public LocalListStatsImpl getLocalCollectionStats(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localCollectionStatsConstructorFunction);
    }
}

