/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ProductionVariantInstanceType;
import com.amazonaws.services.sagemaker.model.transform.ProductionVariantMarshaller;
import java.io.Serializable;

public class ProductionVariant
implements Serializable,
Cloneable,
StructuredPojo {
    private String variantName;
    private String modelName;
    private Integer initialInstanceCount;
    private String instanceType;
    private Float initialVariantWeight;

    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public ProductionVariant withVariantName(String variantName) {
        this.setVariantName(variantName);
        return this;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public ProductionVariant withModelName(String modelName) {
        this.setModelName(modelName);
        return this;
    }

    public void setInitialInstanceCount(Integer initialInstanceCount) {
        this.initialInstanceCount = initialInstanceCount;
    }

    public Integer getInitialInstanceCount() {
        return this.initialInstanceCount;
    }

    public ProductionVariant withInitialInstanceCount(Integer initialInstanceCount) {
        this.setInitialInstanceCount(initialInstanceCount);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ProductionVariant withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public ProductionVariant withInstanceType(ProductionVariantInstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setInitialVariantWeight(Float initialVariantWeight) {
        this.initialVariantWeight = initialVariantWeight;
    }

    public Float getInitialVariantWeight() {
        return this.initialVariantWeight;
    }

    public ProductionVariant withInitialVariantWeight(Float initialVariantWeight) {
        this.setInitialVariantWeight(initialVariantWeight);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVariantName() != null) {
            sb.append("VariantName: ").append(this.getVariantName()).append(",");
        }
        if (this.getModelName() != null) {
            sb.append("ModelName: ").append(this.getModelName()).append(",");
        }
        if (this.getInitialInstanceCount() != null) {
            sb.append("InitialInstanceCount: ").append(this.getInitialInstanceCount()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getInitialVariantWeight() != null) {
            sb.append("InitialVariantWeight: ").append(this.getInitialVariantWeight());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariant)) {
            return false;
        }
        ProductionVariant other = (ProductionVariant)obj;
        if (other.getVariantName() == null ^ this.getVariantName() == null) {
            return false;
        }
        if (other.getVariantName() != null && !other.getVariantName().equals(this.getVariantName())) {
            return false;
        }
        if (other.getModelName() == null ^ this.getModelName() == null) {
            return false;
        }
        if (other.getModelName() != null && !other.getModelName().equals(this.getModelName())) {
            return false;
        }
        if (other.getInitialInstanceCount() == null ^ this.getInitialInstanceCount() == null) {
            return false;
        }
        if (other.getInitialInstanceCount() != null && !other.getInitialInstanceCount().equals(this.getInitialInstanceCount())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getInitialVariantWeight() == null ^ this.getInitialVariantWeight() == null) {
            return false;
        }
        return other.getInitialVariantWeight() == null || other.getInitialVariantWeight().equals(this.getInitialVariantWeight());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVariantName() == null ? 0 : this.getVariantName().hashCode());
        hashCode = 31 * hashCode + (this.getModelName() == null ? 0 : this.getModelName().hashCode());
        hashCode = 31 * hashCode + (this.getInitialInstanceCount() == null ? 0 : this.getInitialInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInitialVariantWeight() == null ? 0 : this.getInitialVariantWeight().hashCode());
        return hashCode;
    }

    public ProductionVariant clone() {
        try {
            return (ProductionVariant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProductionVariantMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

