/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.VideoMetadata;

@SdkInternalApi
public class VideoMetadataMarshaller {
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Codec").build();
    private static final MarshallingInfo<Long> DURATIONMILLIS_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationMillis").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").build();
    private static final MarshallingInfo<Float> FRAMERATE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameRate").build();
    private static final MarshallingInfo<Long> FRAMEHEIGHT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameHeight").build();
    private static final MarshallingInfo<Long> FRAMEWIDTH_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameWidth").build();
    private static final VideoMetadataMarshaller instance = new VideoMetadataMarshaller();

    public static VideoMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(VideoMetadata videoMetadata, ProtocolMarshaller protocolMarshaller) {
        if (videoMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(videoMetadata.getCodec(), CODEC_BINDING);
            protocolMarshaller.marshall(videoMetadata.getDurationMillis(), DURATIONMILLIS_BINDING);
            protocolMarshaller.marshall(videoMetadata.getFormat(), FORMAT_BINDING);
            protocolMarshaller.marshall(videoMetadata.getFrameRate(), FRAMERATE_BINDING);
            protocolMarshaller.marshall(videoMetadata.getFrameHeight(), FRAMEHEIGHT_BINDING);
            protocolMarshaller.marshall(videoMetadata.getFrameWidth(), FRAMEWIDTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

