/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mq.model.ConfigurationId;

@SdkInternalApi
public class ConfigurationIdMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<Integer> REVISION_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").build();
    private static final ConfigurationIdMarshaller instance = new ConfigurationIdMarshaller();

    public static ConfigurationIdMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConfigurationId configurationId, ProtocolMarshaller protocolMarshaller) {
        if (configurationId == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(configurationId.getId(), ID_BINDING);
            protocolMarshaller.marshall(configurationId.getRevision(), REVISION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

