/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.services.mediaconvert.model.Rectangle;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class RectangleJsonUnmarshaller
implements Unmarshaller<Rectangle, JsonUnmarshallerContext> {
    private static RectangleJsonUnmarshaller instance;

    @Override
    public Rectangle unmarshall(JsonUnmarshallerContext context) throws Exception {
        Rectangle rectangle = new Rectangle();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("height", targetDepth)) {
                    context.nextToken();
                    rectangle.setHeight(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("width", targetDepth)) {
                    context.nextToken();
                    rectangle.setWidth(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("x", targetDepth)) {
                    context.nextToken();
                    rectangle.setX(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("y", targetDepth)) {
                    context.nextToken();
                    rectangle.setY(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return rectangle;
    }

    public static RectangleJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RectangleJsonUnmarshaller();
        }
        return instance;
    }
}

