/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.services.lightsail.model.InstanceHealthSummary;
import com.amazonaws.services.lightsail.model.LoadBalancer;
import com.amazonaws.services.lightsail.model.LoadBalancerTlsCertificateSummary;
import com.amazonaws.services.lightsail.model.transform.InstanceHealthSummaryJsonUnmarshaller;
import com.amazonaws.services.lightsail.model.transform.LoadBalancerTlsCertificateSummaryJsonUnmarshaller;
import com.amazonaws.services.lightsail.model.transform.ResourceLocationJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;

public class LoadBalancerJsonUnmarshaller
implements Unmarshaller<LoadBalancer, JsonUnmarshallerContext> {
    private static LoadBalancerJsonUnmarshaller instance;

    @Override
    public LoadBalancer unmarshall(JsonUnmarshallerContext context) throws Exception {
        LoadBalancer loadBalancer = new LoadBalancer();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setSupportCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setCreatedAt(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setLocation(ResourceLocationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setResourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("dnsName", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setDnsName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("protocol", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setProtocol(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("publicPorts", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setPublicPorts(new ListUnmarshaller<Integer>(context.getUnmarshaller(Integer.class)).unmarshall(context));
                }
                if (context.testExpression("healthCheckPath", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setHealthCheckPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("instancePort", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setInstancePort(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("instanceHealthSummary", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setInstanceHealthSummary(new ListUnmarshaller<InstanceHealthSummary>(InstanceHealthSummaryJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("tlsCertificateSummaries", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setTlsCertificateSummaries(new ListUnmarshaller<LoadBalancerTlsCertificateSummary>(LoadBalancerTlsCertificateSummaryJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("configurationOptions", targetDepth)) {
                    context.nextToken();
                    loadBalancer.setConfigurationOptions(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return loadBalancer;
    }

    public static LoadBalancerJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LoadBalancerJsonUnmarshaller();
        }
        return instance;
    }
}

