/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.guardduty.model.ProductCode;

@SdkInternalApi
public class ProductCodeMarshaller {
    private static final MarshallingInfo<String> CODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("code").build();
    private static final MarshallingInfo<String> PRODUCTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productType").build();
    private static final ProductCodeMarshaller instance = new ProductCodeMarshaller();

    public static ProductCodeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProductCode productCode, ProtocolMarshaller protocolMarshaller) {
        if (productCode == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(productCode.getCode(), CODE_BINDING);
            protocolMarshaller.marshall(productCode.getProductType(), PRODUCTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

