/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.services.glacier.model.Grant;
import com.amazonaws.services.glacier.model.S3Location;
import com.amazonaws.services.glacier.model.transform.EncryptionJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GrantJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3LocationJsonUnmarshaller
implements Unmarshaller<S3Location, JsonUnmarshallerContext> {
    private static S3LocationJsonUnmarshaller instance;

    @Override
    public S3Location unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Location s3Location = new S3Location();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BucketName", targetDepth)) {
                    context.nextToken();
                    s3Location.setBucketName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Prefix", targetDepth)) {
                    context.nextToken();
                    s3Location.setPrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Encryption", targetDepth)) {
                    context.nextToken();
                    s3Location.setEncryption(EncryptionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CannedACL", targetDepth)) {
                    context.nextToken();
                    s3Location.setCannedACL(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AccessControlList", targetDepth)) {
                    context.nextToken();
                    s3Location.setAccessControlList(new ListUnmarshaller<Grant>(GrantJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Tagging", targetDepth)) {
                    context.nextToken();
                    s3Location.setTagging(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("UserMetadata", targetDepth)) {
                    context.nextToken();
                    s3Location.setUserMetadata(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("StorageClass", targetDepth)) {
                    context.nextToken();
                    s3Location.setStorageClass(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Location;
    }

    public static S3LocationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3LocationJsonUnmarshaller();
        }
        return instance;
    }
}

