/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.RelativeFileVersionEnum;
import com.amazonaws.services.codecommit.model.transform.LocationMarshaller;
import java.io.Serializable;

public class Location
implements Serializable,
Cloneable,
StructuredPojo {
    private String filePath;
    private Long filePosition;
    private String relativeFileVersion;

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Location withFilePath(String filePath) {
        this.setFilePath(filePath);
        return this;
    }

    public void setFilePosition(Long filePosition) {
        this.filePosition = filePosition;
    }

    public Long getFilePosition() {
        return this.filePosition;
    }

    public Location withFilePosition(Long filePosition) {
        this.setFilePosition(filePosition);
        return this;
    }

    public void setRelativeFileVersion(String relativeFileVersion) {
        this.relativeFileVersion = relativeFileVersion;
    }

    public String getRelativeFileVersion() {
        return this.relativeFileVersion;
    }

    public Location withRelativeFileVersion(String relativeFileVersion) {
        this.setRelativeFileVersion(relativeFileVersion);
        return this;
    }

    public Location withRelativeFileVersion(RelativeFileVersionEnum relativeFileVersion) {
        this.relativeFileVersion = relativeFileVersion.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilePath() != null) {
            sb.append("FilePath: ").append(this.getFilePath()).append(",");
        }
        if (this.getFilePosition() != null) {
            sb.append("FilePosition: ").append(this.getFilePosition()).append(",");
        }
        if (this.getRelativeFileVersion() != null) {
            sb.append("RelativeFileVersion: ").append(this.getRelativeFileVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (other.getFilePath() == null ^ this.getFilePath() == null) {
            return false;
        }
        if (other.getFilePath() != null && !other.getFilePath().equals(this.getFilePath())) {
            return false;
        }
        if (other.getFilePosition() == null ^ this.getFilePosition() == null) {
            return false;
        }
        if (other.getFilePosition() != null && !other.getFilePosition().equals(this.getFilePosition())) {
            return false;
        }
        if (other.getRelativeFileVersion() == null ^ this.getRelativeFileVersion() == null) {
            return false;
        }
        return other.getRelativeFileVersion() == null || other.getRelativeFileVersion().equals(this.getRelativeFileVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilePath() == null ? 0 : this.getFilePath().hashCode());
        hashCode = 31 * hashCode + (this.getFilePosition() == null ? 0 : this.getFilePosition().hashCode());
        hashCode = 31 * hashCode + (this.getRelativeFileVersion() == null ? 0 : this.getRelativeFileVersion().hashCode());
        return hashCode;
    }

    public Location clone() {
        try {
            return (Location)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

